/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.otel.bridge;

import io.micrometer.tracing.Baggage;
import io.micrometer.tracing.BaggageManager;
import io.micrometer.tracing.CurrentTraceContext;
import io.micrometer.tracing.TraceContext;
import io.micrometer.tracing.otel.bridge.CompositeBaggage;
import io.micrometer.tracing.otel.bridge.Entry;
import io.micrometer.tracing.otel.bridge.OtelBaggageInScope;
import io.micrometer.tracing.otel.bridge.OtelTraceContext;
import io.opentelemetry.api.baggage.BaggageEntryMetadata;
import io.opentelemetry.context.Context;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OtelBaggageManager
implements BaggageManager {
    private static final String PROPAGATION_UNLIMITED = "propagation=unlimited";
    private final CurrentTraceContext currentTraceContext;
    private final List<String> remoteFields;
    private final List<String> tagFields;

    public OtelBaggageManager(CurrentTraceContext currentTraceContext, List<String> remoteFields, List<String> tagFields) {
        this.currentTraceContext = currentTraceContext;
        this.remoteFields = remoteFields;
        this.tagFields = tagFields;
    }

    public Map<String, String> getAllBaggage() {
        HashMap<String, String> baggage = new HashMap<String, String>();
        this.currentBaggage().getEntries().forEach(entry -> baggage.put(entry.getKey(), entry.getValue()));
        return baggage;
    }

    CompositeBaggage currentBaggage() {
        OtelTraceContext traceContext = (OtelTraceContext)this.currentTraceContext.context();
        Context context = Context.current();
        ArrayDeque<Context> stack = new ArrayDeque<Context>();
        if (traceContext != null) {
            stack.addFirst(traceContext.context());
        }
        stack.addFirst(context);
        return new CompositeBaggage(stack);
    }

    public Baggage getBaggage(String name) {
        Entry entry = this.getBaggage(name, this.currentBaggage());
        return this.createNewEntryIfMissing(name, entry);
    }

    Baggage createNewEntryIfMissing(String name, Entry entry) {
        if (entry == null) {
            return this.createBaggage(name);
        }
        return this.otelBaggage(entry);
    }

    private Entry getBaggage(String name, io.opentelemetry.api.baggage.Baggage baggage) {
        return this.entryForName(name, baggage);
    }

    public Baggage getBaggage(TraceContext traceContext, String name) {
        OtelTraceContext context = (OtelTraceContext)traceContext;
        ArrayDeque<Context> stack = new ArrayDeque<Context>();
        Context current = Context.current();
        Context traceContextContext = context.context();
        stack.addFirst(current);
        if (current != traceContextContext) {
            stack.addFirst(traceContextContext);
        }
        Context ctx = this.removeFirst(stack);
        Entry entry = null;
        while (ctx != null && entry == null) {
            entry = this.getBaggage(name, io.opentelemetry.api.baggage.Baggage.fromContext((Context)ctx));
            ctx = this.removeFirst(stack);
        }
        return this.createNewEntryIfMissing(name, entry);
    }

    Entry getEntry(OtelTraceContext traceContext, String name) {
        OtelTraceContext context = traceContext;
        Context ctx = context.context();
        return this.getBaggage(name, io.opentelemetry.api.baggage.Baggage.fromContext((Context)ctx));
    }

    Context removeFirst(Deque<Context> stack) {
        return stack.isEmpty() ? null : stack.removeFirst();
    }

    private Entry entryForName(String name, io.opentelemetry.api.baggage.Baggage baggage) {
        return Entry.fromBaggage(baggage).stream().filter(e -> e.getKey().equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    private Baggage otelBaggage(Entry entry) {
        return new OtelBaggageInScope(this, this.currentTraceContext, this.tagFields, entry);
    }

    public Baggage createBaggage(String name) {
        return this.createBaggage(name, "");
    }

    public Baggage createBaggage(String name, String value) {
        Baggage baggage = this.baggageWithValue(name, "");
        return baggage.set(value);
    }

    private Baggage baggageWithValue(String name, String value) {
        boolean remoteField = this.remoteFields.stream().map(String::toLowerCase).anyMatch(s -> s.equals(name.toLowerCase()));
        BaggageEntryMetadata entryMetadata = BaggageEntryMetadata.create((String)this.propagationString(remoteField));
        Entry entry = new Entry(name, value, entryMetadata);
        return new OtelBaggageInScope(this, this.currentTraceContext, this.tagFields, entry);
    }

    private String propagationString(boolean remoteField) {
        String propagation = "";
        if (remoteField) {
            propagation = PROPAGATION_UNLIMITED;
        }
        return propagation;
    }
}

