/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.otel.bridge;

import io.micrometer.tracing.Span;
import io.micrometer.tracing.TraceContext;
import io.micrometer.tracing.otel.bridge.OtelSpanBuilder;
import io.micrometer.tracing.otel.bridge.OtelTraceContext;
import io.micrometer.tracing.propagation.Propagator;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapPropagator;
import java.util.ArrayList;
import java.util.List;

public class OtelPropagator
implements Propagator {
    private final TextMapPropagator propagator;
    private final Tracer tracer;

    public OtelPropagator(ContextPropagators propagation, Tracer tracer) {
        this.propagator = propagation.getTextMapPropagator();
        this.tracer = tracer;
    }

    public List<String> fields() {
        return new ArrayList<String>(this.propagator.fields());
    }

    public <C> void inject(TraceContext traceContext, C carrier, Propagator.Setter<C> setter) {
        Context context = OtelTraceContext.toOtelContext(traceContext);
        this.propagator.inject(context, carrier, (arg_0, arg_1, arg_2) -> setter.set(arg_0, arg_1, arg_2));
    }

    public <C> Span.Builder extract(C carrier, final Propagator.Getter<C> getter) {
        Context extracted = this.propagator.extract(Context.current(), carrier, new TextMapGetter<C>(){

            public Iterable<String> keys(C carrier) {
                return OtelPropagator.this.fields();
            }

            public String get(C carrier, String key) {
                return getter.get(carrier, key);
            }
        });
        Span span = Span.fromContextOrNull((Context)extracted);
        OtelTraceContext otelTraceContext = OtelPropagator.getOtelTraceContext(extracted, span);
        return OtelSpanBuilder.fromOtel(this.tracer.spanBuilder("")).setParent((TraceContext)otelTraceContext);
    }

    private static OtelTraceContext getOtelTraceContext(Context extracted, Span span) {
        if (span == null || span.equals(Span.getInvalid())) {
            Span invalid = Span.getInvalid();
            return new OtelTraceContext(extracted, invalid.getSpanContext(), invalid);
        }
        return new OtelTraceContext(extracted, span.getSpanContext(), span);
    }
}

