/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.otel.bridge;

import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.trace.ReadWriteSpan;
import io.opentelemetry.sdk.trace.ReadableSpan;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.Collection;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class ArrayListSpanProcessor
implements SpanProcessor,
SpanExporter {
    private final Queue<SpanData> spans = new ConcurrentLinkedQueue<SpanData>();

    public void onStart(Context parent, ReadWriteSpan span) {
    }

    public boolean isStartRequired() {
        return false;
    }

    public void onEnd(ReadableSpan span) {
        this.spans.add(span.toSpanData());
    }

    public boolean isEndRequired() {
        return true;
    }

    public CompletableResultCode export(Collection<SpanData> spans) {
        this.spans.addAll(spans.stream().filter(f -> !this.spans.contains(f)).collect(Collectors.toList()));
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode shutdown() {
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode forceFlush() {
        return CompletableResultCode.ofSuccess();
    }

    public void close() {
        this.shutdown().join(10L, TimeUnit.SECONDS);
    }

    public SpanData takeLocalSpan() {
        return this.spans.poll();
    }

    public Queue<SpanData> spans() {
        return this.spans;
    }

    public void clear() {
        this.spans.clear();
    }

    public String toString() {
        return "ArrayListSpanProcessor{spans=" + this.spans + '}';
    }
}

