/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.otel.bridge;

import io.micrometer.common.lang.Nullable;
import io.micrometer.tracing.Link;
import io.micrometer.tracing.Span;
import io.micrometer.tracing.TraceContext;
import io.micrometer.tracing.exporter.FinishedSpan;
import io.micrometer.tracing.otel.bridge.OtelTraceContext;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.data.DelegatingSpanData;
import io.opentelemetry.sdk.trace.data.EventData;
import io.opentelemetry.sdk.trace.data.LinkData;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.semconv.SemanticAttributes;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.time.Instant;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class OtelFinishedSpan
implements FinishedSpan {
    private final MutableSpanData spanData;
    @Nullable
    private volatile String linkLocalIp;

    OtelFinishedSpan(SpanData spanData) {
        this.spanData = new MutableSpanData(spanData);
    }

    public static FinishedSpan fromOtel(SpanData span) {
        return new OtelFinishedSpan(span);
    }

    public static SpanData toOtel(FinishedSpan span) {
        return ((OtelFinishedSpan)span).spanData;
    }

    public FinishedSpan setName(String name) {
        this.spanData.name = name;
        return this;
    }

    public String getName() {
        return this.spanData.getName();
    }

    public Instant getStartTimestamp() {
        return Instant.ofEpochSecond(0L, this.spanData.getStartEpochNanos());
    }

    public Instant getEndTimestamp() {
        return Instant.ofEpochSecond(0L, this.spanData.getEndEpochNanos());
    }

    public FinishedSpan setTags(Map<String, String> tags) {
        this.spanData.tags.clear();
        this.spanData.tags.putAll(tags.entrySet().stream().collect(Collectors.toMap(e -> AttributeKey.stringKey((String)((String)e.getKey())), Map.Entry::getValue)));
        return this;
    }

    public Map<String, String> getTags() {
        return this.spanData.tags.entrySet().stream().collect(Collectors.toMap(e -> ((AttributeKey)e.getKey()).getKey(), entry -> String.valueOf(entry.getValue())));
    }

    public FinishedSpan setTypedTags(Map<String, Object> tags) {
        this.spanData.tags.clear();
        this.spanData.tags.putAll(tags.entrySet().stream().collect(Collectors.toMap(e -> {
            Object value = e.getValue();
            return OtelFinishedSpan.getAttributeKey((String)e.getKey(), value);
        }, Map.Entry::getValue)));
        return this;
    }

    private static AttributeKey getAttributeKey(String key, Object value) {
        if (value instanceof Double) {
            return AttributeKey.doubleKey((String)key);
        }
        if (value instanceof Long) {
            return AttributeKey.longKey((String)key);
        }
        if (value instanceof Boolean) {
            return AttributeKey.booleanKey((String)key);
        }
        if (value instanceof List) {
            List valueAsList = (List)value;
            if (valueAsList.isEmpty()) {
                return AttributeKey.stringArrayKey((String)key);
            }
            Object firstValue = valueAsList.get(0);
            if (firstValue instanceof Double) {
                return AttributeKey.doubleArrayKey((String)key);
            }
            if (firstValue instanceof Long) {
                return AttributeKey.longArrayKey((String)key);
            }
            if (firstValue instanceof Boolean) {
                return AttributeKey.doubleArrayKey((String)key);
            }
            return AttributeKey.stringArrayKey((String)key);
        }
        return AttributeKey.stringKey((String)key);
    }

    public Map<String, Object> getTypedTags() {
        return this.spanData.tags.entrySet().stream().collect(Collectors.toMap(e -> ((AttributeKey)e.getKey()).getKey(), Map.Entry::getValue));
    }

    public FinishedSpan setEvents(Collection<Map.Entry<Long, String>> events) {
        this.spanData.events.clear();
        this.spanData.events.addAll(events.stream().map(e -> EventData.create((long)((Long)e.getKey()), (String)((String)e.getValue()), (Attributes)Attributes.empty())).collect(Collectors.toList()));
        return this;
    }

    public Collection<Map.Entry<Long, String>> getEvents() {
        return this.spanData.getEvents().stream().map(e -> new AbstractMap.SimpleEntry<Long, String>(e.getEpochNanos(), e.getName())).collect(Collectors.toList());
    }

    public String getSpanId() {
        return this.spanData.getSpanId();
    }

    @Nullable
    public String getParentId() {
        return this.spanData.getParentSpanId();
    }

    @Nullable
    public String getRemoteIp() {
        return this.getTags().get(SemanticAttributes.NET_SOCK_PEER_ADDR.getKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLocalIp() {
        if (this.linkLocalIp != null) {
            return this.linkLocalIp;
        }
        OtelFinishedSpan otelFinishedSpan = this;
        synchronized (otelFinishedSpan) {
            if (this.linkLocalIp == null) {
                this.linkLocalIp = this.produceLinkLocalIp();
            }
        }
        return this.linkLocalIp;
    }

    public FinishedSpan setLocalIp(String ip) {
        this.linkLocalIp = ip;
        return this;
    }

    @Nullable
    private String produceLinkLocalIp() {
        try {
            Enumeration<NetworkInterface> nics = NetworkInterface.getNetworkInterfaces();
            while (nics.hasMoreElements()) {
                NetworkInterface nic = nics.nextElement();
                Enumeration<InetAddress> addresses = nic.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress address = addresses.nextElement();
                    if (!address.isSiteLocalAddress()) continue;
                    return address.getHostAddress();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public int getRemotePort() {
        String port = this.getTags().get("net.peer.port");
        if (port == null) {
            return 0;
        }
        return Integer.parseInt(port);
    }

    public FinishedSpan setRemotePort(int port) {
        this.spanData.tags.put(AttributeKey.longKey((String)"net.peer.port"), String.valueOf(port));
        return this;
    }

    public String getTraceId() {
        return this.spanData.getTraceId();
    }

    @Nullable
    public Throwable getError() {
        Attributes attributes = this.spanData.getEvents().stream().filter(e -> e.getName().equals("exception")).findFirst().map(EventData::getAttributes).orElse(null);
        if (attributes != null) {
            return new AssertingThrowable(attributes);
        }
        return null;
    }

    public FinishedSpan setError(Throwable error) {
        this.spanData.getEvents().add(EventData.create((long)System.nanoTime(), (String)"exception", (Attributes)Attributes.of((AttributeKey)AttributeKey.stringKey((String)"exception.message"), (Object)error.toString())));
        return this;
    }

    public Span.Kind getKind() {
        if (this.spanData.getKind() == SpanKind.INTERNAL) {
            return null;
        }
        return Span.Kind.valueOf((String)this.spanData.getKind().name());
    }

    @Nullable
    public String getRemoteServiceName() {
        return (String)this.spanData.getAttributes().get(AttributeKey.stringKey((String)"peer.service"));
    }

    public FinishedSpan setRemoteServiceName(String remoteServiceName) {
        this.spanData.tags.put(AttributeKey.stringKey((String)"peer.service"), remoteServiceName);
        return this;
    }

    public String getLocalServiceName() {
        return (String)this.spanData.getResource().getAttribute(AttributeKey.stringKey((String)"service.name"));
    }

    public FinishedSpan setLocalServiceName(String localServiceName) {
        this.spanData.resources.put(AttributeKey.stringKey((String)"service.name"), localServiceName);
        return this;
    }

    public List<Link> getLinks() {
        return this.spanData.getLinks().stream().map(linkData -> new Link(OtelTraceContext.fromOtel(linkData.getSpanContext()), linkData.getAttributes().asMap().entrySet().stream().collect(Collectors.toMap(e -> ((AttributeKey)e.getKey()).getKey(), e -> String.valueOf(e.getValue()))))).collect(Collectors.toList());
    }

    public FinishedSpan addLinks(List<Link> links) {
        links.forEach(this::addLink);
        return this;
    }

    public FinishedSpan addLink(Link link) {
        TraceContext traceContext = link.getTraceContext();
        Map tags = link.getTags();
        AttributesBuilder builder = Attributes.builder();
        tags.forEach((s, o) -> builder.put(OtelFinishedSpan.getAttributeKey(s, o), o));
        this.spanData.getLinks().add(LinkData.create((SpanContext)OtelTraceContext.toOtelSpanContext(traceContext), (Attributes)builder.build()));
        return this;
    }

    public String toString() {
        return "SpanDataToReportedSpan{spanData=" + (Object)((Object)this.spanData) + '}';
    }

    static class MutableSpanData
    extends DelegatingSpanData {
        String name;
        long startEpochNanos;
        long endEpochNanos;
        final Map<AttributeKey, Object> tags = new HashMap<AttributeKey, Object>();
        final Map<AttributeKey, Object> resources = new HashMap<AttributeKey, Object>();
        final List<EventData> events = new ArrayList<EventData>();
        final List<LinkData> links = new ArrayList<LinkData>();

        MutableSpanData(SpanData delegate) {
            super(delegate);
            this.name = delegate.getName();
            this.startEpochNanos = delegate.getStartEpochNanos();
            this.endEpochNanos = delegate.getEndEpochNanos();
            delegate.getAttributes().forEach(this.tags::put);
            this.events.addAll(delegate.getEvents());
            this.links.addAll(delegate.getLinks());
            this.resources.putAll(delegate.getResource().getAttributes().asMap());
        }

        public String getName() {
            return this.name;
        }

        public long getStartEpochNanos() {
            return this.startEpochNanos;
        }

        public Attributes getAttributes() {
            AttributesBuilder builder = Attributes.builder();
            for (Map.Entry<AttributeKey, Object> entry : this.tags.entrySet()) {
                builder = builder.put(entry.getKey(), entry.getValue());
            }
            return builder.build();
        }

        public List<EventData> getEvents() {
            return this.events;
        }

        public long getEndEpochNanos() {
            return this.endEpochNanos;
        }

        public int getTotalRecordedEvents() {
            return this.getEvents().size();
        }

        public int getTotalAttributeCount() {
            return this.getAttributes().size();
        }

        public List<LinkData> getLinks() {
            return this.links;
        }

        public Resource getResource() {
            AttributesBuilder builder = Attributes.builder();
            for (Map.Entry<AttributeKey, Object> entry : this.resources.entrySet()) {
                builder = builder.put(entry.getKey(), entry.getValue());
            }
            return Resource.create((Attributes)builder.build());
        }
    }

    public static class AssertingThrowable
    extends Throwable {
        public final Attributes attributes;

        AssertingThrowable(Attributes attributes) {
            super((String)attributes.get(AttributeKey.stringKey((String)"exception.message")));
            this.attributes = attributes;
        }
    }
}

