/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.otel.bridge;

import io.micrometer.common.util.StringUtils;
import io.micrometer.tracing.Link;
import io.micrometer.tracing.Span;
import io.micrometer.tracing.TraceContext;
import io.micrometer.tracing.otel.bridge.OtelSpan;
import io.micrometer.tracing.otel.bridge.OtelTraceContext;
import io.micrometer.tracing.otel.bridge.SpanFromSpanContext;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.semconv.SemanticAttributes;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

class OtelSpanBuilder
implements Span.Builder {
    static final String REMOTE_SERVICE_NAME_KEY = "peer.service";
    private final Tracer tracer;
    private final List<String> annotations = new LinkedList<String>();
    private final AttributesBuilder attributes = Attributes.builder();
    private String name;
    private Throwable error;
    private TraceContext parentTraceContext;
    private boolean noParent;
    private SpanKind spanKind = SpanKind.INTERNAL;
    private long startTimestamp;
    private TimeUnit startTimestampUnit;
    private List<Map.Entry<SpanContext, Attributes>> links = new ArrayList<Map.Entry<SpanContext, Attributes>>();

    OtelSpanBuilder(Tracer tracer) {
        this.tracer = tracer;
    }

    static Span.Builder fromOtel(Tracer tracer) {
        return new OtelSpanBuilder(tracer);
    }

    public Span.Builder setParent(TraceContext context) {
        this.parentTraceContext = context;
        return this;
    }

    public Span.Builder setNoParent() {
        this.noParent = true;
        return this;
    }

    public Span.Builder name(String name) {
        this.name = name;
        return this;
    }

    public Span.Builder event(String value) {
        this.annotations.add(value);
        return this;
    }

    public Span.Builder tag(String key, String value) {
        this.attributes.put(key, value);
        return this;
    }

    public Span.Builder tag(String key, long value) {
        this.attributes.put(key, value);
        return this;
    }

    public Span.Builder tag(String key, double value) {
        this.attributes.put(key, value);
        return this;
    }

    public Span.Builder tag(String key, boolean value) {
        this.attributes.put(key, value);
        return this;
    }

    public Span.Builder tagOfStrings(String key, List<String> values) {
        this.attributes.put(AttributeKey.stringArrayKey((String)key), values);
        return this;
    }

    public Span.Builder tagOfLongs(String key, List<Long> values) {
        this.attributes.put(AttributeKey.longArrayKey((String)key), values);
        return this;
    }

    public Span.Builder tagOfDoubles(String key, List<Double> values) {
        this.attributes.put(AttributeKey.doubleArrayKey((String)key), values);
        return this;
    }

    public Span.Builder tagOfBooleans(String key, List<Boolean> values) {
        this.attributes.put(AttributeKey.booleanArrayKey((String)key), values);
        return this;
    }

    public Span.Builder error(Throwable throwable) {
        this.error = throwable;
        return this;
    }

    public Span.Builder kind(Span.Kind spanKind) {
        if (spanKind == null) {
            this.spanKind = SpanKind.INTERNAL;
            return this;
        }
        SpanKind kind = SpanKind.INTERNAL;
        switch (spanKind) {
            case CLIENT: {
                kind = SpanKind.CLIENT;
                break;
            }
            case SERVER: {
                kind = SpanKind.SERVER;
                break;
            }
            case PRODUCER: {
                kind = SpanKind.PRODUCER;
                break;
            }
            case CONSUMER: {
                kind = SpanKind.CONSUMER;
            }
        }
        this.spanKind = kind;
        return this;
    }

    public Span.Builder remoteServiceName(String remoteServiceName) {
        this.attributes.put(REMOTE_SERVICE_NAME_KEY, remoteServiceName);
        return this;
    }

    public Span.Builder remoteIpAndPort(String ip, int port) {
        this.attributes.put(SemanticAttributes.NET_SOCK_PEER_ADDR.getKey(), ip);
        this.attributes.put(SemanticAttributes.NET_PEER_PORT.getKey(), (long)port);
        return this;
    }

    public Span.Builder startTimestamp(long startTimestamp, TimeUnit unit) {
        this.startTimestamp = startTimestamp;
        this.startTimestampUnit = unit;
        return this;
    }

    public Span.Builder addLink(Link link) {
        TraceContext traceContext = link.getTraceContext();
        SpanContext spanContext = ((OtelTraceContext)traceContext).spanContext();
        AttributesBuilder otelAttributes = Attributes.empty().toBuilder();
        for (Map.Entry entry : link.getTags().entrySet()) {
            otelAttributes = otelAttributes.put(OtelSpanBuilder.getAttributeKey((String)entry.getKey(), entry.getValue()), entry.getValue());
        }
        this.links.add(new AbstractMap.SimpleEntry<SpanContext, Attributes>(spanContext, otelAttributes.build()));
        return this;
    }

    private static AttributeKey getAttributeKey(String key, Object value) {
        if (value instanceof Double) {
            return AttributeKey.doubleKey((String)key);
        }
        if (value instanceof Long) {
            return AttributeKey.longKey((String)key);
        }
        if (value instanceof Boolean) {
            return AttributeKey.booleanKey((String)key);
        }
        return AttributeKey.stringKey((String)key);
    }

    public Span start() {
        SpanBuilder spanBuilder = this.tracer.spanBuilder(StringUtils.isNotEmpty((String)this.name) ? this.name : "");
        if (this.parentTraceContext != null) {
            spanBuilder.setParent(OtelTraceContext.toOtelContext(this.parentTraceContext));
        }
        if (this.noParent) {
            spanBuilder.setNoParent();
        }
        spanBuilder.setAllAttributes(this.attributes.build());
        spanBuilder.setSpanKind(this.spanKind);
        if (this.startTimestampUnit != null) {
            spanBuilder.setStartTimestamp(this.startTimestamp, this.startTimestampUnit);
        }
        this.links.forEach(e -> spanBuilder.addLink((SpanContext)e.getKey(), (Attributes)e.getValue()));
        io.opentelemetry.api.trace.Span span = spanBuilder.startSpan();
        if (this.error != null) {
            span.recordException(this.error);
            span.setStatus(StatusCode.ERROR, this.error.getMessage());
        }
        this.annotations.forEach(arg_0 -> ((io.opentelemetry.api.trace.Span)span).addEvent(arg_0));
        if (this.parentTraceContext != null) {
            return OtelSpan.fromOtel(new SpanFromSpanContext(span, span.getSpanContext(), (OtelTraceContext)this.parentTraceContext));
        }
        return OtelSpan.fromOtel(span);
    }
}

