/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.otel.bridge;

import io.micrometer.common.util.internal.logging.InternalLogger;
import io.micrometer.common.util.internal.logging.InternalLoggerFactory;
import io.micrometer.tracing.Baggage;
import io.micrometer.tracing.BaggageInScope;
import io.micrometer.tracing.CurrentTraceContext;
import io.micrometer.tracing.TraceContext;
import io.micrometer.tracing.otel.bridge.Entry;
import io.micrometer.tracing.otel.bridge.OtelBaggageManager;
import io.micrometer.tracing.otel.bridge.OtelTraceContext;
import io.opentelemetry.api.baggage.BaggageBuilder;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.Scope;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.jspecify.annotations.Nullable;

class OtelBaggageInScope
implements Baggage,
BaggageInScope {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(OtelBaggageInScope.class);
    private final OtelBaggageManager otelBaggageManager;
    private final CurrentTraceContext currentTraceContext;
    private final List<String> tagFields;
    private final AtomicReference<Entry> entry = new AtomicReference();
    private final AtomicReference<Context> contextWithoutBaggage = new AtomicReference<Object>(null);
    private final AtomicReference<OtelTraceContext> mutatedTraceContext = new AtomicReference<Object>(null);
    private final AtomicReference<Context> contextWithBaggage = new AtomicReference<Object>(null);
    private final AtomicReference<Scope> scope = new AtomicReference();

    OtelBaggageInScope(OtelBaggageManager otelBaggageManager, CurrentTraceContext currentTraceContext, List<String> tagFields, Entry entry) {
        this.otelBaggageManager = otelBaggageManager;
        this.currentTraceContext = currentTraceContext;
        this.mutatedTraceContext.set((OtelTraceContext)currentTraceContext.context());
        this.tagFields = tagFields;
        this.entry.set(entry);
        if (entry.value != null) {
            this.updateAttributesForBaggage(entry.value, Span.current());
        }
    }

    OtelBaggageInScope(OtelBaggageManager otelBaggageManager, CurrentTraceContext currentTraceContext, OtelTraceContext traceContext, List<String> tagFields, Entry entry) {
        this.otelBaggageManager = otelBaggageManager;
        this.currentTraceContext = currentTraceContext;
        this.mutatedTraceContext.set(traceContext);
        this.tagFields = tagFields;
        this.entry.set(entry);
    }

    public String name() {
        return this.entry().getKey();
    }

    public @Nullable String get() {
        if (this.entry.get() != null) {
            return this.entry.get().value;
        }
        return this.otelBaggageManager.currentBaggage().getEntryValue(this.entry().getKey());
    }

    public @Nullable String get(TraceContext traceContext) {
        Entry entry = this.otelBaggageManager.getEntry((OtelTraceContext)traceContext, this.entry().getKey());
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    @Deprecated
    public Baggage set(@Nullable String value) {
        return this.doSet(this.currentTraceContext.context(), value);
    }

    private Baggage doSet(@Nullable TraceContext context, @Nullable String value) {
        if (context == null) {
            return this;
        }
        Context current = Context.current();
        Span currentSpan = Span.current();
        OtelTraceContext ctx = (OtelTraceContext)context;
        if (!Objects.equals(this.mutatedTraceContext.get(), ctx)) {
            log.trace("This is unexpected - someone created baggage when mutatedTraceContext was current and now when makeCurrent() was called a new traceContext is present");
        }
        this.mutatedTraceContext.set(ctx);
        Context storedCtx = ctx.context();
        this.contextWithoutBaggage.set(storedCtx);
        io.opentelemetry.api.baggage.Baggage fromContext = io.opentelemetry.api.baggage.Baggage.fromContext((Context)storedCtx);
        BaggageBuilder newBaggageBuilder = fromContext.toBuilder();
        io.opentelemetry.api.baggage.Baggage.current().forEach((key, baggageEntry) -> newBaggageBuilder.put(key, baggageEntry.getValue(), baggageEntry.getMetadata()));
        io.opentelemetry.api.baggage.Baggage baggage = newBaggageBuilder.put(this.entry().getKey(), value, this.entry().getMetadata()).build();
        current = current.with((ImplicitContextKeyed)baggage);
        Context withBaggage = current.with((ImplicitContextKeyed)baggage);
        ctx.updateContext(withBaggage);
        this.contextWithBaggage.set(withBaggage);
        this.updateAttributesForBaggage(value, currentSpan);
        Entry previous = this.entry();
        this.entry.set(new Entry(previous.getKey(), value, previous.getMetadata()));
        return this;
    }

    private void updateAttributesForBaggage(@Nullable String value, Span currentSpan) {
        if (this.tagFields.stream().anyMatch(s -> s.equalsIgnoreCase(this.entry().getKey()))) {
            currentSpan.setAttribute(this.entry().getKey(), value);
        }
    }

    private Entry entry() {
        return this.entry.get();
    }

    @Deprecated
    public Baggage set(TraceContext traceContext, @Nullable String value) {
        return this.doSet(traceContext, value);
    }

    public BaggageInScope makeCurrent(@Nullable String value) {
        return this.doSet(this.currentTraceContext.context(), value).makeCurrent();
    }

    public BaggageInScope makeCurrent(TraceContext traceContext, @Nullable String value) {
        return this.doSet(traceContext, value).makeCurrent();
    }

    public BaggageInScope makeCurrent() {
        Entry storedEntry = this.entry();
        Context context = this.contextWithBaggage.get();
        if (context == null) {
            context = Context.current();
        }
        io.opentelemetry.api.baggage.Baggage baggage = io.opentelemetry.api.baggage.Baggage.fromContext((Context)context).toBuilder().put(storedEntry.getKey(), storedEntry.getValue(), storedEntry.getMetadata()).build();
        Context updated = context.with((ImplicitContextKeyed)baggage);
        OtelTraceContext otelTraceContext = this.mutatedTraceContext.get();
        if (otelTraceContext != null) {
            otelTraceContext.updateContext(updated);
        }
        Scope currentScope = updated.makeCurrent();
        this.scope.set(currentScope);
        return this;
    }

    public void close() {
        Scope scope = this.scope.get();
        if (scope != null) {
            this.scope.set(null);
            scope.close();
            OtelTraceContext traceContext = this.mutatedTraceContext.get();
            if (traceContext != null) {
                traceContext.updateContext(this.contextWithoutBaggage.get());
            }
        }
    }

    public String toString() {
        return "OtelBaggageInScope{tagFields=" + this.tagFields + ", entry=" + this.entry + '}';
    }
}

