/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.otel.propagation;

import io.micrometer.common.util.internal.logging.InternalLogger;
import io.micrometer.common.util.internal.logging.InternalLoggerFactory;
import io.micrometer.tracing.BaggageManager;
import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.baggage.BaggageBuilder;
import io.opentelemetry.api.baggage.BaggageEntryMetadata;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.context.propagation.TextMapSetter;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;

public class BaggageTextMapPropagator
implements TextMapPropagator {
    private static final String PROPAGATION_UNLIMITED = "propagation=unlimited";
    private static final InternalLogger log = InternalLoggerFactory.getInstance(BaggageTextMapPropagator.class);
    private final List<String> remoteFields;
    private final BaggageManager baggageManager;

    public BaggageTextMapPropagator(List<String> remoteFields, BaggageManager baggageManager) {
        this.remoteFields = remoteFields;
        this.baggageManager = baggageManager;
    }

    public List<String> fields() {
        return this.remoteFields;
    }

    public <C> void inject(Context context, @Nullable C carrier, TextMapSetter<C> setter) {
        List<Map.Entry<String, String>> baggageEntries = this.applicableBaggageEntries();
        baggageEntries.forEach(e -> setter.set(carrier, (String)e.getKey(), (String)e.getValue()));
    }

    private List<Map.Entry<String, String>> applicableBaggageEntries() {
        Map allBaggage = this.baggageManager.getAllBaggage();
        List lowerCaseKeys = this.remoteFields.stream().map(String::toLowerCase).collect(Collectors.toList());
        return allBaggage.entrySet().stream().filter(e -> lowerCaseKeys.contains(((String)e.getKey()).toLowerCase())).collect(Collectors.toList());
    }

    public <C> Context extract(Context context, @Nullable C carrier, TextMapGetter<C> getter) {
        BaggageBuilder newBaggage = Baggage.fromContext((Context)context).toBuilder();
        Map<String, String> carierEntries = this.extractFromCarrier(carrier, getter);
        carierEntries.forEach((key, value) -> newBaggage.put(key, value, BaggageEntryMetadata.create((String)PROPAGATION_UNLIMITED)));
        return context.with((ImplicitContextKeyed)newBaggage.build());
    }

    private <C> Map<String, String> extractFromCarrier(@Nullable C carrier, TextMapGetter<C> getter) {
        Map<String, String> carierEntries = this.remoteFields.stream().map(s -> new AbstractMap.SimpleEntry<String, String>((String)s, getter.get(carrier, s))).filter(e -> e.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (log.isDebugEnabled()) {
            log.debug("Will propagate new baggage context for entries " + carierEntries);
        }
        return carierEntries;
    }
}

