/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.test.simple;

import io.micrometer.common.lang.Nullable;
import io.micrometer.tracing.Span;
import io.micrometer.tracing.SpanAndScope;
import io.micrometer.tracing.TraceContext;
import io.micrometer.tracing.Tracer;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class SimpleSpanAndScope
extends SpanAndScope {
    private static final Map<TraceContext, Span> traceContextToSpans = new ConcurrentHashMap<TraceContext, Span>();
    private final TraceContext traceContext;

    public SimpleSpanAndScope(Span span, @Nullable Tracer.SpanInScope scope) {
        super(span, scope);
        this.traceContext = span.context();
    }

    public SimpleSpanAndScope(TraceContext traceContext, @Nullable Tracer.SpanInScope scope) {
        super(Objects.requireNonNull(traceContextToSpans.get(traceContext), "You must create a span with this context before"), scope);
        this.traceContext = traceContext;
    }

    public TraceContext getTraceContext() {
        return this.traceContext;
    }

    static void bindSpanToTraceContext(TraceContext traceContext, Span span) {
        traceContextToSpans.put(traceContext, span);
    }

    static Span getSpanForTraceContext(TraceContext traceContext) {
        return traceContextToSpans.get(traceContext);
    }
}

