/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.test.simple;

import io.micrometer.tracing.CurrentTraceContext;
import io.micrometer.tracing.Span;
import io.micrometer.tracing.TraceContext;
import io.micrometer.tracing.test.simple.SimpleSpan;
import io.micrometer.tracing.test.simple.SimpleSpanAndScope;
import io.micrometer.tracing.test.simple.SimpleSpanInScope;
import io.micrometer.tracing.test.simple.SimpleTracer;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;

public class SimpleCurrentTraceContext
implements CurrentTraceContext {
    private final SimpleTracer simpleTracer;

    public SimpleCurrentTraceContext(SimpleTracer simpleTracer) {
        this.simpleTracer = simpleTracer;
    }

    public TraceContext context() {
        SimpleSpan span = this.simpleTracer.currentSpan();
        if (span != null) {
            return span.context();
        }
        return null;
    }

    public CurrentTraceContext.Scope newScope(TraceContext context) {
        Span span = Objects.requireNonNull(SimpleSpanAndScope.getSpanForTraceContext(context), "You must create a span with this context before");
        SimpleSpanInScope inScope = this.simpleTracer.withSpan(span);
        return inScope::close;
    }

    public CurrentTraceContext.Scope maybeScope(TraceContext context) {
        Span span = Objects.requireNonNull(SimpleSpanAndScope.getSpanForTraceContext(context), "You must create a span with this context before");
        if (this.simpleTracer.currentSpan() == span) {
            return () -> {};
        }
        return this.newScope(span.context());
    }

    public <C> Callable<C> wrap(Callable<C> task) {
        return task;
    }

    public Runnable wrap(Runnable task) {
        return task;
    }

    public Executor wrap(Executor delegate) {
        return delegate;
    }

    public ExecutorService wrap(ExecutorService delegate) {
        return delegate;
    }
}

