/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.test.simple;

import io.micrometer.tracing.Span;
import io.micrometer.tracing.exporter.FinishedSpan;
import io.micrometer.tracing.test.simple.Clock;
import io.micrometer.tracing.test.simple.SimpleSpanAndScope;
import io.micrometer.tracing.test.simple.SimpleTraceContext;
import java.time.Instant;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class SimpleSpan
implements Span,
FinishedSpan {
    private final Map<String, String> tags = new ConcurrentHashMap<String, String>();
    private volatile boolean abandoned;
    private volatile long startMillis;
    private volatile long endMillis;
    private volatile Throwable throwable;
    private volatile String remoteServiceName;
    private volatile Span.Kind spanKind;
    private final Map<Long, String> events = new ConcurrentHashMap<Long, String>();
    private volatile String name;
    private volatile String ip;
    private volatile int port;
    private volatile boolean noop;
    private final Clock clock = Clock.SYSTEM;
    private final SimpleTraceContext context = new SimpleTraceContext();

    public SimpleSpan() {
        SimpleSpanAndScope.bindSpanToTraceContext(this.context(), this);
    }

    public boolean isNoop() {
        return this.noop;
    }

    public SimpleTraceContext context() {
        return this.context;
    }

    public SimpleSpan start() {
        this.startMillis = this.clock.wallTime();
        return this;
    }

    public SimpleSpan name(String name) {
        this.name = name;
        return this;
    }

    public SimpleSpan event(String value) {
        this.events.put(TimeUnit.MILLISECONDS.toMicros(this.clock.wallTime()), value);
        return this;
    }

    public Span event(String value, long time, TimeUnit timeUnit) {
        this.events.put(timeUnit.toMicros(time), value);
        return this;
    }

    public SimpleSpan tag(String key, String value) {
        this.tags.put(key, value);
        return this;
    }

    public SimpleSpan error(Throwable throwable) {
        this.throwable = throwable;
        return this;
    }

    public SimpleSpan remoteIpAndPort(String ip, int port) {
        this.ip = ip;
        this.port = port;
        return this;
    }

    public void end() {
        this.endMillis = this.clock.wallTime();
    }

    public void end(long time, TimeUnit timeUnit) {
        this.endMillis = timeUnit.toMicros(time);
    }

    public void abandon() {
        this.abandoned = true;
    }

    public SimpleSpan remoteServiceName(String remoteServiceName) {
        this.remoteServiceName = remoteServiceName;
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public FinishedSpan setEvents(Collection<Map.Entry<Long, String>> events) {
        return this;
    }

    public Collection<Map.Entry<Long, String>> getEvents() {
        return this.events.entrySet();
    }

    void setStartMillis(long startMillis) {
        this.startMillis = startMillis;
    }

    public String getRemoteServiceName() {
        return this.remoteServiceName;
    }

    public FinishedSpan setRemoteServiceName(String remoteServiceName) {
        return this;
    }

    void setSpanKind(Span.Kind kind) {
        this.spanKind = kind;
    }

    public String getSpanId() {
        return this.context.spanId();
    }

    public String getParentId() {
        return this.context.parentId();
    }

    public String getRemoteIp() {
        return this.ip;
    }

    public String getLocalIp() {
        return this.ip;
    }

    public FinishedSpan setLocalIp(String ip) {
        return this;
    }

    public int getRemotePort() {
        return this.port;
    }

    public FinishedSpan setRemotePort(int port) {
        return this;
    }

    public String getTraceId() {
        return this.context.traceId();
    }

    public Throwable getError() {
        return this.throwable;
    }

    public FinishedSpan setError(Throwable error) {
        return this;
    }

    public Span.Kind getKind() {
        return this.spanKind;
    }

    public FinishedSpan setName(String name) {
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Instant getStartTimestamp() {
        return Instant.ofEpochMilli(this.startMillis);
    }

    public Instant getEndTimestamp() {
        return Instant.ofEpochMilli(this.endMillis);
    }

    public FinishedSpan setTags(Map<String, String> tags) {
        return this;
    }

    public Clock getClock() {
        return this.clock;
    }

    public String toString() {
        return "SimpleSpan{tags=" + this.tags + ", abandoned=" + this.abandoned + ", startMillis=" + this.startMillis + ", endMillis=" + this.endMillis + ", throwable=" + this.throwable + ", remoteServiceName='" + this.remoteServiceName + '\'' + ", spanKind=" + this.spanKind + ", events=" + this.events + ", name='" + this.name + '\'' + ", ip='" + this.ip + '\'' + ", port=" + this.port + ", noop=" + this.noop + ", clock=" + this.clock + ", context=" + this.context + '}';
    }
}

