/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.test.simple;

import io.micrometer.common.docs.KeyName;
import io.micrometer.tracing.exporter.FinishedSpan;
import io.micrometer.tracing.test.simple.SpanAssert;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.assertj.core.api.CollectionAssert;

public class SpansAssert
extends CollectionAssert<FinishedSpan> {
    protected SpansAssert(Collection<? extends FinishedSpan> actual) {
        super(actual);
    }

    public static SpansAssert assertThat(Collection<? extends FinishedSpan> actual) {
        return new SpansAssert(actual);
    }

    public static SpansAssert then(Collection<? extends FinishedSpan> actual) {
        return new SpansAssert(actual);
    }

    public SpansAssert haveSameTraceId() {
        this.isNotEmpty();
        List traceIds = ((Collection)this.actual).stream().map(FinishedSpan::getTraceId).distinct().collect(Collectors.toList());
        if (traceIds.size() != 1) {
            this.failWithMessage("Spans should have same trace ids but found %s trace ids. Found following spans \n%s", new Object[]{traceIds, this.spansAsString()});
        }
        return this;
    }

    private String spansAsString() {
        return ((Collection)this.actual).stream().map(Object::toString).collect(Collectors.joining("\n"));
    }

    public SpansAssert hasASpanWithName(String name) {
        this.isNotEmpty();
        this.extractSpanWithName(name);
        return this;
    }

    public SpansAssert hasASpanWithName(String name, Consumer<SpanAssert> spanConsumer) {
        this.isNotEmpty();
        this.atLeastOneSpanPassesTheAssertion(name, spanConsumer);
        return this;
    }

    private void atLeastOneSpanPassesTheAssertion(String name, Consumer<SpanAssert> spanConsumer) {
        FinishedSpan finishedSpan = ((Collection)this.actual).stream().filter(f -> name.equals(f.getName())).filter(f -> {
            try {
                spanConsumer.accept(SpanAssert.assertThat(f));
                return true;
            }
            catch (AssertionError e) {
                return false;
            }
        }).findFirst().orElse(null);
        if (finishedSpan == null) {
            this.failWithMessage("Not a single span with name <%s> was found or has passed the assertion. Found following spans %s", new Object[]{name, this.spansAsString()});
        }
    }

    public SpansAssert hasASpanWithNameIgnoreCase(String name, Consumer<SpanAssert> spanConsumer) {
        this.isNotEmpty();
        this.atLeastOneSpanPassesTheAssertionIgnoreCase(name, spanConsumer);
        return this;
    }

    private void atLeastOneSpanPassesTheAssertionIgnoreCase(String name, Consumer<SpanAssert> spanConsumer) {
        FinishedSpan finishedSpan = ((Collection)this.actual).stream().filter(f -> name.equalsIgnoreCase(f.getName())).filter(f -> {
            try {
                spanConsumer.accept(SpanAssert.assertThat(f));
                return true;
            }
            catch (AssertionError e) {
                return false;
            }
        }).findFirst().orElse(null);
        if (finishedSpan == null) {
            this.failWithMessage("Not a single span with name <%s> was found (ignoring case) or has passed the assertion. Found following spans %s", new Object[]{name, this.spansAsString()});
        }
    }

    private FinishedSpan extractSpanWithName(String name) {
        return ((Collection)this.actual).stream().filter(f -> name.equals(f.getName())).findFirst().orElseThrow(() -> {
            this.failWithMessage("There should be at least one span with name <%s> but found none. Found following spans \n%s", new Object[]{name, this.spansAsString()});
            return new AssertionError();
        });
    }

    private FinishedSpan extractSpanWithNameIgnoreCase(String name) {
        return ((Collection)this.actual).stream().filter(f -> name.equalsIgnoreCase(f.getName())).findFirst().orElseThrow(() -> {
            this.failWithMessage("There should be at least one span with name (ignore case) <%s> but found none. Found following spans \n%s", new Object[]{name, this.spansAsString()});
            return new AssertionError();
        });
    }

    public SpansAssert hasASpanWithNameIgnoreCase(String name) {
        this.isNotEmpty();
        ((Collection)this.actual).stream().filter(f -> name.equalsIgnoreCase(f.getName())).findFirst().orElseThrow(() -> {
            this.failWithMessage("There should be at least one span with name (ignoring case) <%s> but found none. Found following spans \n%s", new Object[]{name, this.spansAsString()});
            return new AssertionError();
        });
        return this;
    }

    public SpansAssert forAllSpansWithNameEqualTo(String name, Consumer<SpanAssert> spanConsumer) {
        this.isNotEmpty();
        this.hasASpanWithName(name);
        ((Collection)this.actual).stream().filter(f -> name.equals(f.getName())).forEach(f -> spanConsumer.accept(SpanAssert.then(f)));
        return this;
    }

    public SpansAssert forAllSpansWithNameEqualToIgnoreCase(String name, Consumer<SpanAssert> spanConsumer) {
        this.isNotEmpty();
        this.hasASpanWithNameIgnoreCase(name);
        ((Collection)this.actual).stream().filter(f -> name.equalsIgnoreCase(f.getName())).forEach(f -> spanConsumer.accept(SpanAssert.then(f)));
        return this;
    }

    public SpansAssertReturningAssert assertThatASpanWithNameEqualTo(String name) {
        this.isNotEmpty();
        FinishedSpan span = this.extractSpanWithName(name);
        return new SpansAssertReturningAssert(this, span);
    }

    public SpansAssertReturningAssert thenASpanWithNameEqualTo(String name) {
        return this.assertThatASpanWithNameEqualTo(name);
    }

    public SpansAssertReturningAssert assertThatASpanWithNameEqualToIgnoreCase(String name) {
        this.isNotEmpty();
        FinishedSpan span = this.extractSpanWithNameIgnoreCase(name);
        return new SpansAssertReturningAssert(this, span);
    }

    public SpansAssertReturningAssert thenASpanWithNameEqualToIgnoreCase(String name) {
        return this.assertThatASpanWithNameEqualToIgnoreCase(name);
    }

    public SpansAssert hasNumberOfSpansEqualTo(int expectedNumberOfSpans) {
        this.isNotEmpty();
        if (((Collection)this.actual).size() != expectedNumberOfSpans) {
            this.failWithMessage("There should be <%s> spans but there were <%s>. Found following spans \n%s", new Object[]{expectedNumberOfSpans, ((Collection)this.actual).size(), this.spansAsString()});
        }
        return this;
    }

    public SpansAssert hasNumberOfSpansWithNameEqualTo(String spanName, int expectedNumberOfSpans) {
        this.isNotEmpty();
        long spansWithNameSize = ((Collection)this.actual).stream().filter(f -> spanName.equals(f.getName())).count();
        if (spansWithNameSize != (long)expectedNumberOfSpans) {
            this.failWithMessage("There should be <%s> spans with name <%s> but there were <%s>. Found following spans \n%s", new Object[]{expectedNumberOfSpans, spanName, spansWithNameSize, this.spansAsString()});
        }
        return this;
    }

    public SpansAssert hasNumberOfSpansWithNameEqualToIgnoreCase(String spanName, int expectedNumberOfSpans) {
        this.isNotEmpty();
        long spansWithNameSize = ((Collection)this.actual).stream().filter(f -> spanName.equalsIgnoreCase(f.getName())).count();
        if (spansWithNameSize != (long)expectedNumberOfSpans) {
            this.failWithMessage("There should be <%s> spans with name (ignoring case) <%s> but there were <%s>. Found following spans \n%s", new Object[]{expectedNumberOfSpans, spanName, spansWithNameSize, this.spansAsString()});
        }
        return this;
    }

    public SpansAssert hasASpanWithRemoteServiceName(String remoteServiceName) {
        this.isNotEmpty();
        ((Collection)this.actual).stream().filter(f -> remoteServiceName.equals(f.getRemoteServiceName())).findFirst().orElseThrow(() -> {
            this.failWithMessage("There should be at least one span with remote service name <%s> but found none. Found following spans \n%s", new Object[]{remoteServiceName, this.spansAsString()});
            return new AssertionError();
        });
        return this;
    }

    public SpansAssert hasASpanWithATag(String key, String value) {
        this.isNotEmpty();
        ((Collection)this.actual).stream().filter(f -> {
            String tag = (String)f.getTags().get(key);
            return value.equals(tag);
        }).findFirst().orElseThrow(() -> {
            this.failWithMessage("There should be at least one span with tag key <%s> and value <%s> but found none. Found following spans \n%s", new Object[]{key, value, this.spansAsString()});
            return new AssertionError();
        });
        return this;
    }

    public SpansAssert hasASpanWithATagKey(String key) {
        this.isNotEmpty();
        ((Collection)this.actual).stream().filter(f -> f.getTags().containsKey(key)).findFirst().orElseThrow(() -> {
            this.failWithMessage("There should be at least one span with tag key <%s> but found none. Found following spans \n%s", new Object[]{key, this.spansAsString()});
            return new AssertionError();
        });
        return this;
    }

    public SpansAssert hasASpanWithATag(KeyName key, String value) {
        return this.hasASpanWithATag(key.asString(), value);
    }

    public SpansAssert hasASpanWithATagKey(KeyName key) {
        return this.hasASpanWithATagKey(key.asString());
    }

    public static class SpansAssertReturningAssert
    extends SpanAssert<SpansAssertReturningAssert> {
        private final SpansAssert spansAssert;

        public SpansAssertReturningAssert(SpansAssert spansAssert, FinishedSpan span) {
            super(span);
            this.spansAssert = spansAssert;
        }

        public SpansAssert backToSpans() {
            return this.spansAssert;
        }
    }
}

