/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.handler;

import io.micrometer.common.KeyValue;
import io.micrometer.common.lang.NonNull;
import io.micrometer.common.lang.Nullable;
import io.micrometer.common.util.StringUtils;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationHandler;
import io.micrometer.observation.ObservationView;
import io.micrometer.tracing.CurrentTraceContext;
import io.micrometer.tracing.Span;
import io.micrometer.tracing.Tracer;
import io.micrometer.tracing.internal.SpanNameUtil;

public interface TracingObservationHandler<T extends Observation.Context>
extends ObservationHandler<T> {
    default public void tagSpan(T context, Span span) {
        for (KeyValue keyValue : context.getAllKeyValues()) {
            if (!keyValue.getKey().equalsIgnoreCase("ERROR")) {
                span.tag(keyValue.getKey(), keyValue.getValue());
                continue;
            }
            span.error(new RuntimeException(keyValue.getValue()));
        }
    }

    default public String getSpanName(T context) {
        String name = context.getName();
        if (StringUtils.isNotBlank((String)context.getContextualName())) {
            name = context.getContextualName();
        }
        return SpanNameUtil.toLowerHyphen(name);
    }

    default public void onScopeOpened(T context) {
        Span span = this.getTracingContext(context).getSpan();
        if (span == null) {
            return;
        }
        CurrentTraceContext.Scope scope = this.getTracer().currentTraceContext().maybeScope(span.context());
        this.getTracingContext(context).setSpanAndScope(span, scope);
    }

    default public void onEvent(Observation.Event event, T context) {
        this.getRequiredSpan(context).event(event.getContextualName());
    }

    default public void onError(T context) {
        if (context.getError() != null) {
            this.getRequiredSpan(context).error(context.getError());
        }
    }

    default public void onScopeClosed(T context) {
        TracingContext tracingContext = this.getTracingContext(context);
        tracingContext.getScope().close();
    }

    @Nullable
    default public Span getParentSpan(Observation.ContextView context) {
        TracingContext tracingContext = (TracingContext)context.get(TracingContext.class);
        if (tracingContext == null) {
            ObservationView observation = context.getParentObservation();
            if (observation != null && (tracingContext = (TracingContext)observation.getContextView().get(TracingContext.class)) != null) {
                return tracingContext.getSpan();
            }
        } else {
            return tracingContext.getSpan();
        }
        return null;
    }

    @NonNull
    default public TracingContext getTracingContext(T context) {
        return (TracingContext)context.computeIfAbsent(TracingContext.class, clazz -> new TracingContext());
    }

    default public boolean supportsContext(Observation.Context context) {
        return context != null;
    }

    default public Span getRequiredSpan(T context) {
        Span span = this.getTracingContext(context).getSpan();
        if (span == null) {
            throw new IllegalStateException("Span wasn't started - an observation must be started (not only created)");
        }
        return span;
    }

    public Tracer getTracer();

    public static class TracingContext {
        private Span span;
        private CurrentTraceContext.Scope scope;

        public Span getSpan() {
            return this.span;
        }

        public void setSpan(Span span) {
            this.span = span;
        }

        public CurrentTraceContext.Scope getScope() {
            return this.scope;
        }

        public void setScope(CurrentTraceContext.Scope scope) {
            this.scope = scope;
        }

        public void setSpanAndScope(Span span, CurrentTraceContext.Scope scope) {
            this.setSpan(span);
            this.setScope(scope);
        }

        public String toString() {
            return "TracingContext{span=" + this.span + ", scope=" + this.scope + '}';
        }
    }
}

