/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing;

import io.micrometer.common.lang.NonNull;
import io.micrometer.tracing.Span;
import io.micrometer.tracing.TraceContext;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;

public class Link {
    public static final Link NOOP = new Link(TraceContext.NOOP, Collections.emptyMap());
    private final TraceContext traceContext;
    private final Map<String, Object> tags;

    public Link(TraceContext traceContext, Map<String, Object> tags) {
        this.traceContext = traceContext;
        this.tags = tags;
    }

    public Link(TraceContext traceContext) {
        this.traceContext = traceContext;
        this.tags = Collections.emptyMap();
    }

    public Link(Span span, Map<String, Object> tags) {
        this.traceContext = span.context();
        this.tags = tags;
    }

    public Link(Span span) {
        this.traceContext = span.context();
        this.tags = Collections.emptyMap();
    }

    @NonNull
    public TraceContext getTraceContext() {
        return this.traceContext;
    }

    @NonNull
    public Map<String, Object> getTags() {
        return this.tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Link link = (Link)o;
        return Objects.equals(this.traceContext, link.traceContext) && Objects.equals(this.tags, link.tags);
    }

    public int hashCode() {
        return Objects.hash(this.traceContext, this.tags);
    }

    public String toString() {
        return "Link{traceContext=" + this.traceContext + ", tags=" + this.tags + '}';
    }
}

