/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing;

import io.micrometer.tracing.Span;
import io.micrometer.tracing.SpanAndScope;
import io.micrometer.tracing.Tracer;
import java.util.ArrayDeque;
import org.jspecify.annotations.Nullable;

public class ThreadLocalSpan {
    private final ThreadLocal<ArrayDeque<SpanAndScope>> currentSpanInScopeStack = new ThreadLocal();
    private final Tracer tracer;

    public ThreadLocalSpan(Tracer tracer) {
        this.tracer = tracer;
    }

    public void set(Span span) {
        Tracer.SpanInScope spanInScope = this.tracer.withSpan(span);
        SpanAndScope newSpanAndScope = new SpanAndScope(span, spanInScope);
        this.getCurrentSpanInScopeStack().addFirst(newSpanAndScope);
    }

    public SpanAndScope get() {
        return this.getCurrentSpanInScopeStack().peekFirst();
    }

    public @Nullable SpanAndScope remove() {
        SpanAndScope spanAndScope = this.getCurrentSpanInScopeStack().pollFirst();
        if (spanAndScope == null) {
            return null;
        }
        if (spanAndScope.getScope() != null) {
            spanAndScope.getScope().close();
        }
        return spanAndScope;
    }

    private ArrayDeque<SpanAndScope> getCurrentSpanInScopeStack() {
        ArrayDeque<SpanAndScope> stack = this.currentSpanInScopeStack.get();
        if (stack == null) {
            stack = new ArrayDeque();
            this.currentSpanInScopeStack.set(stack);
        }
        return stack;
    }
}

