/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.handler;

import io.micrometer.common.KeyValue;
import io.micrometer.common.util.StringUtils;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationHandler;
import io.micrometer.observation.ObservationView;
import io.micrometer.tracing.CurrentTraceContext;
import io.micrometer.tracing.Span;
import io.micrometer.tracing.TraceContext;
import io.micrometer.tracing.Tracer;
import io.micrometer.tracing.handler.RevertingScope;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.jspecify.annotations.Nullable;

public interface TracingObservationHandler<T extends Observation.Context>
extends ObservationHandler<T> {
    default public void tagSpan(T context, Span span) {
        for (KeyValue keyValue : context.getAllKeyValues()) {
            if (!keyValue.getKey().equalsIgnoreCase("ERROR")) {
                span.tag(keyValue.getKey(), keyValue.getValue());
                continue;
            }
            span.error(new RuntimeException(keyValue.getValue()));
        }
    }

    default public String getSpanName(T context) {
        String name = context.getName();
        if (StringUtils.isNotBlank((String)context.getContextualName())) {
            name = context.getContextualName();
        }
        return Objects.requireNonNull(name);
    }

    default public void onScopeOpened(T context) {
        TracingContext tracingContext = this.getTracingContext(context);
        Span span = tracingContext.getSpan();
        this.setMaybeScopeOnTracingContext(tracingContext, span);
    }

    default public void setMaybeScopeOnTracingContext(TracingContext tracingContext, @Nullable Span newSpan) {
        Span spanFromThisObservation = tracingContext.getSpan();
        TraceContext newContext = newSpan != null ? newSpan.context() : null;
        CurrentTraceContext.Scope scope = this.getTracer().currentTraceContext().maybeScope(newContext);
        CurrentTraceContext.Scope previousScopeOnThisObservation = tracingContext.getScope();
        RevertingScope revertingScope = new RevertingScope(tracingContext, scope, previousScopeOnThisObservation);
        revertingScope = RevertingScope.maybeWithBaggage(this.getTracer(), tracingContext, newContext, revertingScope, previousScopeOnThisObservation);
        tracingContext.setSpanAndScope(spanFromThisObservation, revertingScope);
    }

    default public void onScopeReset(T context) {
        TracingContext tracingContext = this.getTracingContext(context);
        CurrentTraceContext.Scope scope = tracingContext.getScope();
        while (scope != null) {
            scope.close();
            scope = tracingContext.getScope();
        }
        this.getTracer().currentTraceContext().maybeScope(null);
    }

    default public void onEvent(Observation.Event event, T context) {
        long timestamp = event.getWallTime();
        if (timestamp == 0L) {
            this.getRequiredSpan(context).event(event.getContextualName());
        } else {
            this.getRequiredSpan(context).event(event.getContextualName(), timestamp, TimeUnit.MILLISECONDS);
        }
    }

    default public void onError(T context) {
        if (context.getError() != null) {
            this.getRequiredSpan(context).error(context.getError());
        }
    }

    default public void onScopeClosed(T context) {
        TracingContext tracingContext = this.getTracingContext(context);
        CurrentTraceContext.Scope scope = tracingContext.getScope();
        if (scope != null) {
            scope.close();
        }
    }

    default public @Nullable Span getParentSpan(Observation.ContextView context) {
        TracingContext tracingContext = (TracingContext)context.get(TracingContext.class);
        Span currentSpan = this.getTracer().currentSpan();
        if (tracingContext == null) {
            ObservationView observation = context.getParentObservation();
            if (observation != null && (tracingContext = (TracingContext)observation.getContextView().get(TracingContext.class)) != null) {
                Span spanFromParentObservation = tracingContext.getSpan();
                if (spanFromParentObservation == null && currentSpan != null) {
                    return currentSpan;
                }
                if (currentSpan != null && !currentSpan.equals(spanFromParentObservation)) {
                    return currentSpan;
                }
                return spanFromParentObservation;
            }
        } else {
            return tracingContext.getSpan();
        }
        return null;
    }

    default public TracingContext getTracingContext(T context) {
        TracingContext tracingContext = (TracingContext)context.computeIfAbsent(TracingContext.class, clazz -> new TracingContext());
        tracingContext.setContext((Observation.ContextView)context);
        return tracingContext;
    }

    default public boolean supportsContext(Observation.Context context) {
        return context != null;
    }

    default public Span getRequiredSpan(T context) {
        Span span = this.getTracingContext(context).getSpan();
        if (span == null) {
            throw new IllegalStateException("Span wasn't started - an observation must be started (not only created)");
        }
        return span;
    }

    default public void endSpan(T context, Span span) {
        TracingContext tracingContext = this.getTracingContext(context);
        tracingContext.close();
        span.end();
    }

    public Tracer getTracer();

    public static class TracingContext
    implements AutoCloseable {
        private @Nullable Span span;
        private Map<Thread, CurrentTraceContext.Scope> scopes = new ConcurrentHashMap<Thread, CurrentTraceContext.Scope>();
        private // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable Observation.ContextView context;

        public @Nullable Span getSpan() {
            return this.span;
        }

        public void setSpan(@Nullable Span span) {
            this.span = span;
        }

        public @Nullable CurrentTraceContext.Scope getScope() {
            return this.scopes.get(Thread.currentThread());
        }

        public void setScope(@Nullable CurrentTraceContext.Scope scope) {
            if (scope == null) {
                this.scopes.remove(Thread.currentThread());
            } else {
                this.scopes.put(Thread.currentThread(), scope);
            }
        }

        @Deprecated
        public Map<String, String> getBaggage() {
            return Collections.emptyMap();
        }

        @Deprecated
        public void setBaggage(Map<String, String> baggage) {
        }

        public void setSpanAndScope(@Nullable Span span, CurrentTraceContext.Scope scope) {
            this.setSpan(span);
            this.setScope(scope);
        }

        @Override
        public void close() {
        }

        public String toString() {
            return "TracingContext{span=" + this.traceContextFromSpan() + '}';
        }

        private String traceContextFromSpan() {
            if (this.span != null) {
                return this.span.context().toString();
            }
            return "null";
        }

        void setContext(Observation.ContextView context) {
            this.context = context;
        }

        // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable Observation.ContextView getContext() {
            return this.context;
        }
    }
}

