/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.prometheus.rsocket;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import io.micrometer.prometheus.rsocket.PrometheusControllerProperties;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.rsocket.Payload;
import io.rsocket.RSocket;
import io.rsocket.core.RSocketServer;
import io.rsocket.frame.decoder.PayloadDecoder;
import io.rsocket.micrometer.MicrometerRSocket;
import io.rsocket.micrometer.MicrometerRSocketInterceptor;
import io.rsocket.transport.ServerTransport;
import io.rsocket.transport.netty.server.TcpServerTransport;
import io.rsocket.transport.netty.server.WebsocketServerTransport;
import io.rsocket.util.DefaultPayload;
import io.rsocket.util.EmptyPayload;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.channels.ClosedChannelException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;
import org.xerial.snappy.Snappy;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
public class PrometheusController {
    private final PrometheusMeterRegistry meterRegistry;
    private final Timer scrapeTimerSuccess;
    private final Timer scrapeTimerClosed;
    private final DistributionSummary scrapePayload;
    private final MicrometerRSocketInterceptor metricsInterceptor;
    private final PrometheusControllerProperties properties;
    private final Map<RSocket, ConnectionState> scrapableApps = new ConcurrentHashMap<RSocket, ConnectionState>();

    public PrometheusController(PrometheusMeterRegistry meterRegistry, PrometheusControllerProperties properties) {
        this.meterRegistry = meterRegistry;
        this.metricsInterceptor = new MicrometerRSocketInterceptor((MeterRegistry)meterRegistry, new Tag[0]);
        this.properties = properties;
        meterRegistry.gaugeMapSize("prometheus.proxy.scrape.active.connections", (Iterable)Tags.empty(), this.scrapableApps);
        this.scrapeTimerSuccess = Timer.builder((String)"prometheus.proxy.scrape").tag("outcome", "success").tag("exception", "none").publishPercentileHistogram().register((MeterRegistry)meterRegistry);
        this.scrapeTimerClosed = meterRegistry.timer("prometheus.proxy.scrape", new String[]{"outcome", "closed", "exception", "none"});
        this.scrapePayload = DistributionSummary.builder((String)"prometheus.proxy.scrape.payload").publishPercentileHistogram().baseUnit("bytes").register((MeterRegistry)meterRegistry);
    }

    @PostConstruct
    public void connect() throws NoSuchAlgorithmException {
        KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA");
        RSocketServer.create().payloadDecoder(PayloadDecoder.ZERO_COPY).acceptor((setup, sendingSocket) -> this.acceptRSocket(generator, sendingSocket)).bind((ServerTransport)TcpServerTransport.create((int)this.properties.getTcpPort())).doOnError(t -> Counter.builder((String)"prometheus.proxy.connection.error").tag("exception", t.getClass().getName()).tag("transport", "TCP").register((MeterRegistry)this.meterRegistry).increment()).subscribe();
        RSocketServer.create().payloadDecoder(PayloadDecoder.ZERO_COPY).acceptor((setup, sendingSocket) -> this.acceptRSocket(generator, sendingSocket)).bind((ServerTransport)WebsocketServerTransport.create((int)this.properties.getWebsocketPort())).doOnError(t -> Counter.builder((String)"prometheus.proxy.connection.error").tag("exception", t.getClass().getName()).tag("transport", "Websocket").register((MeterRegistry)this.meterRegistry).increment()).subscribe();
    }

    private Mono<RSocket> acceptRSocket(KeyPairGenerator generator, RSocket sendingSocket) {
        MicrometerRSocket metricsInterceptedSendingSocket = this.metricsInterceptor.apply(sendingSocket);
        final ConnectionState connectionState = new ConnectionState(generator.generateKeyPair());
        this.scrapableApps.put((RSocket)metricsInterceptedSendingSocket, connectionState);
        metricsInterceptedSendingSocket.fireAndForget(connectionState.createKeyPayload()).subscribe();
        return Mono.just((Object)new RSocket(){

            public Mono<Payload> requestResponse(Payload payload) {
                try {
                    connectionState.setDyingPush(connectionState.receiveScrapePayload(payload, null));
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                return Mono.just((Object)EmptyPayload.INSTANCE);
            }

            public Mono<Void> fireAndForget(Payload payload) {
                try {
                    connectionState.setDyingPush(connectionState.receiveScrapePayload(payload, null));
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                return Mono.empty();
            }
        });
    }

    @GetMapping(value={"/metrics/proxy"}, produces={"text/plain"})
    public Mono<String> proxyMetrics() {
        return Mono.just((Object)this.meterRegistry.scrape());
    }

    @GetMapping(value={"/metrics/connected"}, produces={"text/plain"})
    public Mono<String> prometheus() {
        return Flux.fromIterable(this.scrapableApps.entrySet()).flatMap(socketAndState -> {
            ConnectionState connectionState = (ConnectionState)socketAndState.getValue();
            RSocket rsocket = (RSocket)socketAndState.getKey();
            Timer.Sample sample = Timer.start();
            return rsocket.requestResponse(connectionState.createKeyPayload()).map(payload -> connectionState.receiveScrapePayload((Payload)payload, sample)).onErrorResume(throwable -> {
                this.scrapableApps.remove(rsocket);
                if (throwable instanceof ClosedChannelException) {
                    sample.stop(this.scrapeTimerClosed);
                } else {
                    sample.stop(this.meterRegistry.timer("prometheus.proxy.scrape", new String[]{"outcome", "error", "exception", throwable.getMessage()}));
                }
                return connectionState.getDyingPush();
            });
        }).collect(Collectors.joining("\n"));
    }

    class ConnectionState {
        private final KeyPair keyPair;
        private String dyingPush;

        ConnectionState(KeyPair keyPair) {
            this.keyPair = keyPair;
        }

        Mono<String> getDyingPush() {
            return Mono.justOrEmpty((Object)this.dyingPush);
        }

        void setDyingPush(String dyingPush) {
            this.dyingPush = dyingPush;
        }

        String receiveScrapePayload(Payload payload, Timer.Sample timing) {
            try {
                ByteBuf sliceMetadata = payload.sliceMetadata();
                ByteBuf sliceData = payload.sliceData();
                byte[] decrypted = this.decrypt(this.keyPair, ByteBufUtil.getBytes((ByteBuf)sliceMetadata, (int)sliceMetadata.readerIndex(), (int)sliceMetadata.readableBytes(), (boolean)false), ByteBufUtil.getBytes((ByteBuf)sliceData, (int)sliceData.readerIndex(), (int)sliceData.readableBytes(), (boolean)false));
                String uncompressed = Snappy.uncompressString((byte[])decrypted);
                PrometheusController.this.scrapePayload.record((double)uncompressed.length());
                String string = uncompressed;
                return string;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            finally {
                payload.release();
                if (timing != null) {
                    timing.stop(PrometheusController.this.scrapeTimerSuccess);
                }
            }
        }

        private byte[] decrypt(KeyPair keyPair, byte[] encryptedKey, byte[] data) {
            try {
                PrivateKey privateKey = KeyFactory.getInstance("RSA").generatePrivate(new PKCS8EncodedKeySpec(keyPair.getPrivate().getEncoded()));
                Cipher cipher = Cipher.getInstance("RSA/ECB/OAEPWithSHA-256AndMGF1Padding");
                cipher.init(2, privateKey);
                byte[] decryptedKey = cipher.doFinal(encryptedKey);
                SecretKeySpec originalKey = new SecretKeySpec(decryptedKey, 0, decryptedKey.length, "AES");
                Cipher aesCipher = Cipher.getInstance("AES");
                aesCipher.init(2, originalKey);
                return aesCipher.doFinal(data);
            }
            catch (Throwable e) {
                throw new IllegalStateException(e);
            }
        }

        Payload createKeyPayload() {
            return DefaultPayload.create((byte[])this.keyPair.getPublic().getEncoded());
        }
    }
}

