/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.prometheus.rsocket.autoconfigure;

import io.micrometer.core.instrument.Clock;
import io.micrometer.prometheus.PrometheusConfig;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import io.micrometer.prometheus.rsocket.PrometheusRSocketClient;
import io.micrometer.prometheus.rsocket.autoconfigure.PrometheusRSocketProperties;
import io.prometheus.client.CollectorRegistry;
import io.rsocket.transport.ClientTransport;
import java.time.Duration;
import org.springframework.boot.actuate.autoconfigure.metrics.export.prometheus.PrometheusMetricsExportAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import reactor.util.retry.Retry;

@Configuration
@AutoConfigureAfter(value={PrometheusMetricsExportAutoConfiguration.class})
@ConditionalOnClass(value={PrometheusMeterRegistry.class})
@ConditionalOnProperty(prefix="management.metrics.export.prometheus.rsocket", name={"enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={PrometheusRSocketProperties.class})
public class PrometheusRSocketAutoConfiguration {
    @ConditionalOnMissingBean
    @Bean
    Clock micrometerClock() {
        return Clock.SYSTEM;
    }

    @ConditionalOnMissingBean
    @Bean
    PrometheusConfig prometheusConfig() {
        return PrometheusConfig.DEFAULT;
    }

    @ConditionalOnMissingBean
    @Bean
    CollectorRegistry prometheusCollectorRegistry() {
        return new CollectorRegistry(true);
    }

    @ConditionalOnMissingBean
    @Bean
    PrometheusMeterRegistry prometheusMeterRegistry(PrometheusConfig config, CollectorRegistry collectorRegistry, Clock clock) {
        return new PrometheusMeterRegistry(config, collectorRegistry, clock);
    }

    @ConditionalOnMissingBean
    @Bean(destroyMethod="pushAndClose")
    PrometheusRSocketClient prometheusRSocketClient(PrometheusMeterRegistry meterRegistry, PrometheusRSocketProperties properties) {
        return PrometheusRSocketClient.build((PrometheusMeterRegistry)meterRegistry, (ClientTransport)properties.createClientTransport()).retry((Retry)Retry.backoff((long)properties.getMaxRetries(), (Duration)properties.getFirstBackoff()).maxBackoff(properties.getMaxBackoff())).connect();
    }
}

