/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.prometheus.rsocket.autoconfigure;

import io.rsocket.transport.ClientTransport;
import io.rsocket.transport.netty.client.TcpClientTransport;
import io.rsocket.transport.netty.client.WebsocketClientTransport;
import java.time.Duration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import reactor.netty.http.client.HttpClient;
import reactor.netty.tcp.TcpClient;

@ConfigurationProperties(value="management.metrics.export.prometheus.rsocket")
public class PrometheusRSocketProperties {
    private String host = "localhost";
    private int port = 7001;
    private long maxRetries = Long.MAX_VALUE;
    private Duration firstBackoff = Duration.ofSeconds(10L);
    private Duration maxBackoff = Duration.ofMinutes(10L);
    private Transport transport = Transport.TCP;
    private boolean secure = false;

    public long getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(long maxRetries) {
        this.maxRetries = maxRetries;
    }

    public Duration getFirstBackoff() {
        return this.firstBackoff;
    }

    public void setFirstBackoff(Duration firstBackoff) {
        this.firstBackoff = firstBackoff;
    }

    public Duration getMaxBackoff() {
        return this.maxBackoff;
    }

    public void setMaxBackoff(Duration maxBackoff) {
        this.maxBackoff = maxBackoff;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public Transport getTransport() {
        return this.transport;
    }

    public void setTransport(Transport transport) {
        this.transport = transport;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public boolean isSecure() {
        return this.secure;
    }

    ClientTransport createClientTransport() {
        TcpClient tcpClient = TcpClient.create().host(this.host).port(this.port);
        return this.transport.create(this.secure ? tcpClient.secure() : tcpClient);
    }

    static enum Transport {
        TCP{

            @Override
            ClientTransport create(TcpClient tcpClient) {
                return TcpClientTransport.create((TcpClient)tcpClient);
            }
        }
        ,
        WEBSOCKET{

            @Override
            ClientTransport create(TcpClient tcpClient) {
                return WebsocketClientTransport.create((HttpClient)HttpClient.from((TcpClient)tcpClient), (String)"/");
            }
        };


        abstract ClientTransport create(TcpClient var1);
    }
}

