/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aot;

import com.squareup.javapoet.JavaFile;
import io.micronaut.aot.ConfigKeys;
import io.micronaut.aot.core.AOTContext;
import io.micronaut.aot.core.AOTModule;
import io.micronaut.aot.core.Configuration;
import io.micronaut.aot.core.Option;
import io.micronaut.aot.core.Runtime;
import io.micronaut.aot.core.codegen.ApplicationContextConfigurerGenerator;
import io.micronaut.aot.core.config.DefaultConfiguration;
import io.micronaut.aot.core.config.MetadataUtils;
import io.micronaut.aot.core.config.SourceGeneratorLoader;
import io.micronaut.aot.core.context.ApplicationContextAnalyzer;
import io.micronaut.aot.core.context.DefaultSourceGenerationContext;
import io.micronaut.aot.internal.StreamHelper;
import io.micronaut.core.version.SemanticVersion;
import io.micronaut.core.version.VersionUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MicronautAotOptimizer
implements ConfigKeys {
    public static final String OUTPUT_RESOURCES_FILE_NAME = "resource-filter.txt";
    private static final int MINIMAL_MAJOR = 3;
    private static final int MINIMAL_MINOR = 3;
    private static final Logger LOGGER = LoggerFactory.getLogger(MicronautAotOptimizer.class);
    private final List<File> classpath;
    private final File outputSourcesDirectory;
    private final File outputClassesDirectory;
    private final File logsDirectory;

    private MicronautAotOptimizer(List<File> classpath, File outputSourcesDirectory, File outputClassesDirectory, File logsDirectory) {
        this.classpath = classpath;
        this.outputSourcesDirectory = outputSourcesDirectory;
        this.outputClassesDirectory = outputClassesDirectory;
        this.logsDirectory = logsDirectory;
    }

    private void compileGeneratedSources(List<File> extraClasspath, List<JavaFile> javaFiles) {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        DiagnosticCollector ds = new DiagnosticCollector();
        try (StandardJavaFileManager mgr = compiler.getStandardFileManager(ds, null, null);){
            ArrayList<File> fullClasspath = new ArrayList<File>(this.classpath);
            fullClasspath.addAll(extraClasspath);
            List<String> options = MicronautAotOptimizer.compilerOptions(this.outputClassesDirectory, fullClasspath);
            List<File> filesToCompile = MicronautAotOptimizer.outputSourceFilesToSourceDir(this.outputSourcesDirectory, javaFiles);
            if (this.outputClassesDirectory.exists() || this.outputClassesDirectory.mkdirs()) {
                Iterable<? extends JavaFileObject> sources = mgr.getJavaFileObjectsFromFiles(filesToCompile);
                JavaCompiler.CompilationTask task = compiler.getTask(null, mgr, ds, options, null, sources);
                task.call();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to compile generated classes", e);
        }
        List<Diagnostic<? extends JavaFileObject>> diagnostics = ds.getDiagnostics().stream().filter(d -> d.getKind() == Diagnostic.Kind.ERROR).collect(Collectors.toList());
        if (!diagnostics.isEmpty()) {
            MicronautAotOptimizer.throwCompilationError(diagnostics);
        }
    }

    public static void exportConfiguration(String runtime, File propertiesFile) {
        List list = SourceGeneratorLoader.list((Runtime)Runtime.valueOf((String)runtime.toUpperCase(Locale.ENGLISH)));
        try (PrintWriter wrt = new PrintWriter(new FileOutputStream(propertiesFile));){
            ArrayDeque queue = new ArrayDeque(list);
            while (!queue.isEmpty()) {
                AOTModule generator = (AOTModule)queue.pop();
                if (!generator.description().isEmpty()) {
                    Arrays.stream(generator.description().split("\r?\n")).forEach(line -> wrt.println("# " + line));
                }
                wrt.println(generator.id() + ".enabled = true");
                Arrays.stream(generator.subgenerators()).map(MetadataUtils::findMetadata).filter(Optional::isPresent).map(Optional::get).sorted(Collections.reverseOrder()).forEachOrdered(queue::addFirst);
                for (Option option : generator.options()) {
                    wrt.println(MetadataUtils.toPropertiesSample((Option)option));
                }
                wrt.println();
            }
            wrt.println("# Configures the active environments when the AOT dynamic analysis is performed.");
            wrt.println("target.environments = lambda");
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static void execute(Properties props) {
        DefaultConfiguration config = new DefaultConfiguration(props);
        String pkg = config.mandatoryValue("package");
        File outputDir = new File(config.mandatoryValue("output.directory"));
        File sourcesDir = new File(outputDir, "sources");
        File classesDir = new File(outputDir, "classes");
        File logsDir = new File(outputDir, "logs");
        MicronautAotOptimizer.runner(pkg, sourcesDir, classesDir, logsDir, (Configuration)config).addClasspath(config.stringList("classpath").stream().map(File::new).collect(Collectors.toList())).execute();
    }

    public static Runner runner(String generatedPackage, File outputSourcesDirectory, File outputClassesDirectory, File logsDirectory, Configuration config) {
        return new Runner(generatedPackage, outputSourcesDirectory, outputClassesDirectory, logsDirectory, config);
    }

    private static List<File> outputSourceFilesToSourceDir(File srcDir, List<JavaFile> javaFiles) {
        final ArrayList<File> srcFiles = new ArrayList<File>(javaFiles.size());
        if (srcDir.isDirectory() || srcDir.mkdirs()) {
            StreamHelper.trying(() -> {
                for (JavaFile javaFile : javaFiles) {
                    javaFile.writeTo(srcDir);
                }
                Files.walkFileTree(srcDir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        srcFiles.add(file.toFile());
                        return super.visitFile(file, attrs);
                    }
                });
            });
        }
        return srcFiles;
    }

    private static void throwCompilationError(List<Diagnostic<? extends JavaFileObject>> diagnostics) {
        StringBuilder sb = new StringBuilder("Compilation errors:\n");
        for (Diagnostic<? extends JavaFileObject> d : diagnostics) {
            JavaFileObject source = d.getSource();
            String srcFile = source == null ? "unknown" : new File(source.toUri()).getName();
            String diagLine = String.format("File %s, line: %d, %s", srcFile, d.getLineNumber(), d.getMessage(null));
            sb.append(diagLine).append("\n");
        }
        throw new RuntimeException(sb.toString());
    }

    private static List<String> compilerOptions(File dstDir, List<File> classPath) {
        ArrayList<String> options = new ArrayList<String>();
        options.add("-source");
        options.add("1.8");
        options.add("-target");
        options.add("1.8");
        options.add("-classpath");
        String cp = classPath.stream().map(File::getAbsolutePath).collect(Collectors.joining(File.pathSeparator));
        options.add(cp);
        options.add("-d");
        options.add(dstDir.getAbsolutePath());
        return options;
    }

    private void writeLogs(DefaultSourceGenerationContext context) {
        if (this.logsDirectory.isDirectory() || this.logsDirectory.mkdirs()) {
            MicronautAotOptimizer.writeLines(new File(this.logsDirectory, OUTPUT_RESOURCES_FILE_NAME), context.getExcludedResources());
            context.getDiagnostics().forEach((key, messages) -> {
                File logFile = new File(this.logsDirectory, key.toLowerCase(Locale.US) + ".log");
                MicronautAotOptimizer.writeLines(logFile, messages);
            });
        }
    }

    private static void writeLines(File outputFile, Collection<String> lines) {
        try (PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), StandardCharsets.UTF_8));){
            lines.forEach(writer::println);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static void assertMinimalMicronautVersion() {
        String micronautVersion = VersionUtils.getMicronautVersion();
        if (micronautVersion != null && !SemanticVersion.isAtLeastMajorMinor((String)micronautVersion, (int)3, (int)3)) {
            throw new RuntimeException("This version of the AOT optimizer requires at least Micronaut 3.3 but found " + micronautVersion);
        }
    }

    public static final class Runner {
        private final List<File> classpath = new ArrayList<File>();
        private final String generatedPackage;
        private final File outputSourcesDirectory;
        private final File outputClassesDirectory;
        private final File logsDirectory;
        private final Configuration config;

        public Runner(String generatedPackage, File outputSourcesDirectory, File outputClassesDirectory, File logsDirectory, Configuration config) {
            this.generatedPackage = generatedPackage;
            this.outputSourcesDirectory = outputSourcesDirectory;
            this.outputClassesDirectory = outputClassesDirectory;
            this.logsDirectory = logsDirectory;
            this.config = config;
        }

        public Runner addClasspath(Collection<File> elements) {
            this.classpath.addAll(elements);
            return this;
        }

        public Runner execute() {
            MicronautAotOptimizer optimizer = new MicronautAotOptimizer(this.classpath, this.outputSourcesDirectory, this.outputClassesDirectory, this.logsDirectory);
            ApplicationContextAnalyzer analyzer = ApplicationContextAnalyzer.create(spec -> {
                if (this.config.containsKey("target.environments")) {
                    List targetEnvs = this.config.stringList("target.environments");
                    LOGGER.info("Configuration has explicitly set environments: {} ", (Object)targetEnvs);
                    spec.environments(targetEnvs.toArray(new String[0]));
                }
                MicronautAotOptimizer.assertMinimalMicronautVersion();
            });
            Set environmentNames = analyzer.getEnvironmentNames();
            LOGGER.info("Analysis will be performed with active environments: {}", (Object)environmentNames);
            DefaultSourceGenerationContext context = new DefaultSourceGenerationContext(this.generatedPackage, analyzer, this.config, this.outputClassesDirectory.toPath());
            List sourceGenerators = SourceGeneratorLoader.load((Runtime)this.config.getRuntime(), (AOTContext)context);
            ApplicationContextConfigurerGenerator generator = new ApplicationContextConfigurerGenerator(sourceGenerators);
            generator.generate((AOTContext)context);
            optimizer.compileGeneratedSources(context.getExtraClasspath(), context.getGeneratedJavaFiles());
            optimizer.writeLogs(context);
            return this;
        }
    }
}

