/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aot.cli;

import io.micronaut.aot.ConfigKeys;
import io.micronaut.aot.MicronautAotOptimizer;
import io.micronaut.aot.cli.VersionProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import picocli.CommandLine;

@CommandLine.Command(name="micronaut-aot", mixinStandardHelpOptions=true, versionProvider=VersionProvider.class, description={"Generates classes for Micronaut AOT (build time optimizations)"})
public class Main
implements Runnable,
ConfigKeys {
    @CommandLine.Option(names={"--classpath", "-cp"}, description={"The Micronaut application classpath"}, required=true)
    private String classpathString;
    @CommandLine.Option(names={"--package", "-p"}, description={"The target package for generated classes"}, required=true)
    private String packageName;
    @CommandLine.Option(names={"--runtime"}, description={"The target runtime. Possible values: jit, native"})
    private String runtime = "jit";
    @CommandLine.Option(names={"--config"}, description={"The configuration file (.properties)"}, required=true)
    private File config;
    @CommandLine.Option(names={"--output", "-o"}, description={"The output directory"}, required=false)
    private File outputDirectory;

    @Override
    public void run() {
        List<URL> classpath = Main.toURLs(this.classpathString);
        Properties props = new Properties();
        if (this.config.exists()) {
            try (InputStreamReader reader = new InputStreamReader(new FileInputStream(this.config));){
                props.load(reader);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        props.put("classpath", classpath.stream().map(url -> {
            try {
                return new File(url.toURI()).getAbsolutePath();
            }
            catch (URISyntaxException e) {
                return null;
            }
        }).collect(Collectors.joining(",")));
        props.put("package", this.packageName);
        if (this.outputDirectory != null) {
            props.put("output.directory", this.outputDirectory.getAbsolutePath());
        }
        props.put("runtime", this.runtime);
        URL[] urls = classpath.toArray(new URL[0]);
        this.executeInIsolatedLoader(props, urls, Thread.currentThread().getContextClassLoader());
    }

    private void executeInIsolatedLoader(Properties props, URL[] urls, ClassLoader ctxClassLoader) {
        URLClassLoader cl = new URLClassLoader(urls, (ClassLoader)new FilteringClassLoader(ctxClassLoader));
        try {
            Thread.currentThread().setContextClassLoader(cl);
            Class<?> runnerClass = cl.loadClass("io.micronaut.aot.MicronautAotOptimizer");
            assert (runnerClass != MicronautAotOptimizer.class);
            if (this.outputDirectory != null) {
                runnerClass.getDeclaredMethod("execute", Properties.class).invoke(null, props);
            } else {
                runnerClass.getDeclaredMethod("exportConfiguration", String.class, File.class).invoke(null, this.runtime, this.config);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(ctxClassLoader);
        }
    }

    private static List<URL> toURLs(String classpathString) {
        return Arrays.stream(classpathString.split("[,;" + File.pathSeparator + "]")).map(File::new).map(File::toURI).map(uri -> {
            try {
                return uri.toURL();
            }
            catch (MalformedURLException e) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static int execute(String[] args) {
        return new CommandLine((Object)new Main()).execute(args);
    }

    public static void main(String[] args) {
        System.exit(Main.execute(args));
    }

    private static class FilteringClassLoader
    extends ClassLoader {
        public FilteringClassLoader(ClassLoader ctxClassLoader) {
            super(ctxClassLoader);
        }

        private Class<?> filter(String name, ClassFinder finder) throws ClassNotFoundException {
            if (name.startsWith("io.micronaut")) {
                throw new ClassNotFoundException(name);
            }
            return finder.find(name);
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            return this.filter(name, x$0 -> super.loadClass(x$0));
        }

        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            return this.filter(name, n -> super.loadClass(n, resolve));
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            return this.filter(name, n -> super.findClass(n));
        }

        @FunctionalInterface
        private static interface ClassFinder {
            public Class<?> find(String var1) throws ClassNotFoundException;
        }
    }
}

