/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aot.std.sourcegen;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import io.micronaut.aot.core.AOTContext;
import io.micronaut.aot.core.AOTModule;
import io.micronaut.aot.core.codegen.AbstractCodeGenerator;
import io.micronaut.aot.std.sourcegen.AbstractStaticServiceLoaderSourceGenerator;
import io.micronaut.context.env.CachedEnvironment;
import io.micronaut.context.env.ConstantPropertySources;
import io.micronaut.context.env.PropertySource;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.optim.StaticOptimizations;
import io.micronaut.core.util.EnvironmentProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

@AOTModule(id="sealed.property.source", description="Precomputes property sources at build time", dependencies={"serviceloading.jit", "serviceloading.native"})
public class ConstantPropertySourcesSourceGenerator
extends AbstractCodeGenerator {
    public static final String ID = "sealed.property.source";
    public static final String DESCRIPTION = "Precomputes property sources at build time";

    public void generate(@NonNull AOTContext context) {
        Optional maybeSubstitutes = context.get(AbstractStaticServiceLoaderSourceGenerator.Substitutes.class);
        List substitutes = maybeSubstitutes.map(s -> s.findSubstitutesFor("io.micronaut.context.env.PropertySourceLoader")).orElse(Collections.emptyList()).stream().map(javaFile -> javaFile.packageName + "." + javaFile.typeSpec.name).collect(Collectors.toList());
        CodeBlock.Builder initializer = CodeBlock.builder();
        EnvironmentProperties env = EnvironmentProperties.empty();
        CachedEnvironment.getenv().keySet().forEach(arg_0 -> ((EnvironmentProperties)env).findPropertyNamesForEnvironmentVariable(arg_0));
        initializer.addStatement("$T propertySources = new $T()", new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{ClassName.get(PropertySource.class)}), ParameterizedTypeName.get((ClassName)ClassName.get(ArrayList.class), (TypeName[])new TypeName[]{ClassName.get(PropertySource.class)})});
        for (String substitute : substitutes) {
            initializer.addStatement("propertySources.add(new $T())", new Object[]{ClassName.bestGuess((String)substitute)});
        }
        initializer.addStatement("$T.set(new $T(propertySources))", new Object[]{StaticOptimizations.class, ConstantPropertySources.class});
        context.registerStaticInitializer(ConstantPropertySourcesSourceGenerator.staticMethodBuilder((String)"preparePropertySources", m -> m.addComment("Generates pre-computed Micronaut property sources from known configuration files", new Object[0]).addCode(initializer.build())));
    }
}

