/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aot.std.sourcegen;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.Configurator;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.status.Status;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeSpec;
import io.micronaut.aot.core.AOTContext;
import io.micronaut.aot.core.AOTModule;
import io.micronaut.aot.core.codegen.AbstractSingleClassFileGenerator;
import io.micronaut.core.annotation.NonNull;
import java.lang.reflect.Type;
import java.util.Locale;
import javax.lang.model.element.Modifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AOTModule(id="logback.xml.to.java", description="Replaces logback.xml with a pure Java configuration (NOT YET IMPLEMENTED!)")
public class LogbackConfigurationSourceGenerator
extends AbstractSingleClassFileGenerator {
    public static final String ID = "logback.xml.to.java";
    public static final String DESCRIPTION = "Replaces logback.xml with a pure Java configuration (NOT YET IMPLEMENTED!)";
    private static final Logger LOGGER = LoggerFactory.getLogger(LogbackConfigurationSourceGenerator.class);

    @NonNull
    protected JavaFile generate() {
        LOGGER.warn("The logback.xml conversion feature is not implemented yet. Using hardcoded Java configuration.");
        TypeSpec typeSpec = TypeSpec.classBuilder((String)"StaticLogbackConfiguration").addModifiers(new Modifier[]{Modifier.PUBLIC}).addSuperinterface(Configurator.class).addField(LogbackConfigurationSourceGenerator.contextField()).addMethod(LogbackConfigurationSourceGenerator.configureMethod()).addMethod(LogbackConfigurationSourceGenerator.setcontextMethod()).addMethod(LogbackConfigurationSourceGenerator.getcontextMethod()).addMethod(LogbackConfigurationSourceGenerator.addStatusMethod()).addMethod(LogbackConfigurationSourceGenerator.addLogMethod("Info")).addMethod(LogbackConfigurationSourceGenerator.addLog2Method("Info")).addMethod(LogbackConfigurationSourceGenerator.addLogMethod("Warn")).addMethod(LogbackConfigurationSourceGenerator.addLog2Method("Warn")).addMethod(LogbackConfigurationSourceGenerator.addLogMethod("Error")).addMethod(LogbackConfigurationSourceGenerator.addLog2Method("Error")).build();
        return this.javaFile(typeSpec);
    }

    public void generate(@NonNull AOTContext context) {
        super.generate(context);
        context.registerExcludedResource("logback.xml");
        this.writeServiceFile(context, Configurator.class, "StaticLogbackConfiguration");
    }

    private static MethodSpec addStatusMethod() {
        return MethodSpec.methodBuilder((String)"addStatus").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(Status.class, "status", new Modifier[0]).build();
    }

    private static MethodSpec addLogMethod(String name) {
        return MethodSpec.methodBuilder((String)("add" + name)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(String.class, name.toLowerCase(Locale.US), new Modifier[0]).build();
    }

    private static MethodSpec addLog2Method(String name) {
        return MethodSpec.methodBuilder((String)("add" + name)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(String.class, name.toLowerCase(Locale.US), new Modifier[0]).addParameter(Throwable.class, "ex", new Modifier[0]).build();
    }

    private static MethodSpec getcontextMethod() {
        return MethodSpec.methodBuilder((String)"getContext").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Context.class).addStatement("return context", new Object[0]).build();
    }

    private static MethodSpec setcontextMethod() {
        return MethodSpec.methodBuilder((String)"setContext").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(Context.class, "context", new Modifier[0]).addStatement("this.context = context", new Object[0]).build();
    }

    private static MethodSpec configureMethod() {
        return MethodSpec.methodBuilder((String)"configure").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(LoggerContext.class, "loggerContext", new Modifier[0]).addStatement("$T console = new $T<>()", new Object[]{ParameterizedTypeName.get(ConsoleAppender.class, (Type[])new Type[]{ILoggingEvent.class}), ConsoleAppender.class}).addStatement("console.setWithJansi(true)", new Object[0]).addStatement("console.setContext(context)", new Object[0]).addStatement("$T encoder = new $T();", new Object[]{PatternLayoutEncoder.class, PatternLayoutEncoder.class}).addStatement("encoder.setPattern(\"%cyan(%d{HH:mm:ss.SSS}) %gray([%thread]) %highlight(%-5level) %magenta(%logger{36}) - %msg%n\")", new Object[0]).addStatement("encoder.setContext(context)", new Object[0]).addStatement("console.setEncoder(encoder)", new Object[0]).addStatement("$T logger = loggerContext.getLogger($T.ROOT_LOGGER_NAME)", new Object[]{ch.qos.logback.classic.Logger.class, ch.qos.logback.classic.Logger.class}).addStatement("logger.addAppender(console)", new Object[0]).addStatement("logger.setLevel($T.INFO)", new Object[]{Level.class}).addStatement("logger = loggerContext.getLogger(\"io.micronaut.core.io.service.SoftServiceLoader\")", new Object[0]).addStatement("logger.setLevel($T.DEBUG)", new Object[]{Level.class}).addStatement("logger.setAdditive(false)", new Object[0]).addStatement("logger.addAppender(console)", new Object[0]).addStatement("encoder.start()", new Object[0]).addStatement("console.start()", new Object[0]).build();
    }

    private static FieldSpec contextField() {
        return FieldSpec.builder(Context.class, (String)"context", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE}).build();
    }
}

