/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aot.std.sourcegen;

import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import io.micronaut.aot.core.AOTModule;
import io.micronaut.aot.core.Option;
import io.micronaut.aot.core.codegen.AbstractSingleClassFileGenerator;
import io.micronaut.context.env.MapPropertySource;
import io.micronaut.core.annotation.Generated;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.element.Modifier;

@AOTModule(id="map.property", options={@Option(key="map.property.order", description="The order of the generated property source", sampleValue="1000")})
public class MapPropertySourceGenerator
extends AbstractSingleClassFileGenerator {
    public static final String BASE_ID = "map.property";
    public static final String BASE_ORDER_OPTION = "map.property.order";
    private final String resourceName;
    private final Map<String, Object> values;

    public MapPropertySourceGenerator(String resourceName, Map<String, Object> values) {
        this.resourceName = resourceName;
        this.values = values;
    }

    private CodeBlock generateMap() {
        CodeBlock.Builder mapBuilder = CodeBlock.builder();
        mapBuilder.add("new $T() {{\n", new Object[]{HashMap.class});
        for (Map.Entry<String, Object> entry : this.values.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            mapBuilder.add("put(\"" + key + "\", ", new Object[0]);
            if (value == null) {
                mapBuilder.add("null", new Object[0]);
            } else {
                Class<?> valueClass = value.getClass();
                if (CharSequence.class.isAssignableFrom(valueClass)) {
                    mapBuilder.add("\"" + value + "\"", new Object[0]);
                } else if (Number.class.isAssignableFrom(valueClass) || Boolean.class.isAssignableFrom(valueClass)) {
                    String format = String.valueOf(value);
                    String prefix = "";
                    String appendix = "";
                    if (Long.class.equals(valueClass)) {
                        appendix = "L";
                    } else if (Double.class.equals(valueClass)) {
                        appendix = "D";
                    } else if (Float.class.equals(valueClass)) {
                        appendix = "F";
                    } else if (Byte.class.equals(valueClass)) {
                        prefix = "(byte) ";
                    } else if (Short.class.equals(valueClass)) {
                        prefix = "(short) ";
                    }
                    mapBuilder.add(prefix + format + appendix, new Object[0]);
                } else {
                    throw new UnsupportedOperationException("Configuration map contains an entry of type " + valueClass + " which is not supported yet. Please file a bug report.");
                }
            }
            mapBuilder.add(");\n", new Object[0]);
        }
        mapBuilder.add("}}", new Object[0]);
        return mapBuilder.build();
    }

    @NonNull
    protected JavaFile generate() {
        String typeName = this.computeTypeName();
        String orderKey = "map.property.order." + this.resourceName;
        int order = (Integer)this.getContext().getConfiguration().optionalValue(orderKey, value -> value.map(Integer::parseInt).orElse(Integer.MIN_VALUE));
        TypeSpec type = TypeSpec.classBuilder((String)typeName).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass(MapPropertySource.class).addMethod(MethodSpec.constructorBuilder().addStatement("super($S, $L)", new Object[]{this.resourceName, this.generateMap()}).build()).addMethod(MethodSpec.methodBuilder((String)"getOrder").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE).addStatement("return $L", new Object[]{order}).build()).addAnnotation(Generated.class).build();
        return this.javaFile(type);
    }

    private String computeTypeName() {
        return StringUtils.capitalize((String)(this.resourceName.replaceAll("[^A-Za-z0-9]", "_") + "StaticPropertySource"));
    }
}

