/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aot.std.sourcegen;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import io.micronaut.aot.core.AOTModule;
import io.micronaut.aot.core.Option;
import io.micronaut.aot.core.Runtime;
import io.micronaut.aot.std.sourcegen.AbstractStaticServiceLoaderSourceGenerator;
import io.micronaut.aot.std.sourcegen.YamlPropertySourceGenerator;
import io.micronaut.core.io.service.SoftServiceLoader;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;

@AOTModule(id="serviceloading.jit", description="Scans for service types ahead-of-time, avoiding classpath scanning at startup", options={@Option(key="service.types", description="The list of service types to be scanned (comma separated)", sampleValue="io.micronaut.Service1,io.micronaut.Service2"), @Option(key="serviceloading.rejected.impls", description="A list of implementation types which shouldn't be included in the final application (comma separated)", sampleValue="com.Misc,org.Bar"), @Option(key="serviceloading.force.include.impls", description="A list of implementation types to include even if they don't match bean requirements (comma separated)", sampleValue="com.Misc,org.Bar"), @Option(key="possible.environments", description="The list of environment names that this application can possibly use at runtime.", sampleValue="dev,prod,aws,gcs")}, enabledOn={Runtime.JIT}, subgenerators={YamlPropertySourceGenerator.class})
public class JitStaticServiceLoaderSourceGenerator
extends AbstractStaticServiceLoaderSourceGenerator {
    public static final String ID = "serviceloading.jit";

    @Override
    protected final void generateFindAllMethod(Stream<Class<?>> serviceClasses, String serviceName, Class<?> serviceType, TypeSpec.Builder factory) {
        List initializers = serviceClasses.map(Class::getName).sorted().collect(Collectors.toList());
        ParameterizedTypeName staticDefinitionType = ParameterizedTypeName.get(SoftServiceLoader.StaticDefinition.class, (Type[])new Type[]{serviceType});
        ParameterizedTypeName serviceTypeClassType = ParameterizedTypeName.get(Class.class, (Type[])new Type[]{serviceType});
        CodeBlock.Builder fieldInit = CodeBlock.builder().beginControlFlow("new String[]", new Object[0]);
        for (int i = 0; i < initializers.size(); ++i) {
            String initializer = (String)initializers.get(i);
            fieldInit.add("$S", new Object[]{initializer});
            if (i >= initializers.size() - 1) continue;
            fieldInit.add(",\n", new Object[0]);
        }
        fieldInit.endControlFlow();
        factory.addField(FieldSpec.builder(String[].class, (String)"SERVICE_TYPES", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer(fieldInit.build()).build());
        CodeBlock.Builder init = CodeBlock.builder().addStatement("$T cl = $T.class.getClassLoader()", new Object[]{ClassLoader.class, serviceType}).addStatement("$T pool = $T.commonPool()", new Object[]{ForkJoinPool.class, ForkJoinPool.class});
        for (String initializer : initializers) {
            init.addStatement("pool.submit(() -> loadClass(cl, $S))", new Object[]{initializer});
        }
        factory.addStaticBlock(init.build());
        factory.addMethod(MethodSpec.methodBuilder((String)"loadClass").addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).returns((TypeName)serviceTypeClassType).addParameter(ClassLoader.class, "cl", new Modifier[0]).addParameter(String.class, "name", new Modifier[0]).beginControlFlow("try", new Object[0]).addStatement("return ($T) cl.loadClass(name)", new Object[]{serviceTypeClassType}).endControlFlow().beginControlFlow("catch (Exception e)", new Object[0]).addStatement("return null", new Object[0]).endControlFlow().build());
        MethodSpec.Builder method = MethodSpec.methodBuilder((String)"findAll").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ParameterizedTypeName.get(Predicate.class, (Type[])new Type[]{String.class}), "predicate", new Modifier[0]).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Stream.class), (TypeName[])new TypeName[]{staticDefinitionType}));
        method.addStatement("$T cl = $T.class.getClassLoader()", new Object[]{ClassLoader.class, serviceType});
        method.addStatement("return $T.stream(SERVICE_TYPES)\n.parallel()\n.filter(predicate::test)\n.map(s -> loadClass(cl, s))\n.filter($T::nonNull)\n.map(c -> $T.of(c.getName(), c))", new Object[]{Arrays.class, Objects.class, SoftServiceLoader.StaticDefinition.class});
        factory.addMethod(method.build());
    }
}

