/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aot.std.sourcegen;

import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import io.micronaut.aot.core.AOTModule;
import io.micronaut.aot.core.Option;
import io.micronaut.aot.core.codegen.AbstractSingleClassFileGenerator;
import io.micronaut.context.env.MapPropertySource;
import io.micronaut.core.annotation.Generated;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Modifier;

@AOTModule(id="map.property", options={@Option(key="map.property.order", description="The order of the generated property source", sampleValue="1000")})
public class MapPropertySourceGenerator
extends AbstractSingleClassFileGenerator {
    public static final String BASE_ID = "map.property";
    public static final String BASE_ORDER_OPTION = "map.property.order";
    private final String resourceName;
    private final Map<String, Object> values;
    private int methodCount = 0;

    public MapPropertySourceGenerator(String resourceName, Map<String, Object> values) {
        this.resourceName = resourceName;
        this.values = values;
    }

    private CodeBlock generateMap(TypeSpec.Builder builder) {
        CodeBlock.Builder mapBuilder = CodeBlock.builder();
        mapBuilder.add("new $T() {{\n", new Object[]{HashMap.class});
        for (Map.Entry<String, Object> entry : this.values.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            mapBuilder.add("put(\"" + key + "\", " + this.convertValueToSource(value, builder), new Object[0]);
            mapBuilder.add(");\n", new Object[0]);
        }
        mapBuilder.add("}}", new Object[0]);
        return mapBuilder.build();
    }

    private String convertValueToSource(Object value, TypeSpec.Builder builder) {
        if (value == null) {
            return "null";
        }
        Class<?> valueClass = value.getClass();
        if (CharSequence.class.isAssignableFrom(valueClass)) {
            return "\"" + value + "\"";
        }
        if (Number.class.isAssignableFrom(valueClass) || Boolean.class.isAssignableFrom(valueClass)) {
            String format = String.valueOf(value);
            String prefix = "";
            String appendix = "";
            if (Long.class.equals(valueClass)) {
                appendix = "L";
            } else if (Double.class.equals(valueClass)) {
                appendix = "D";
            } else if (Float.class.equals(valueClass)) {
                appendix = "F";
            } else if (Byte.class.equals(valueClass)) {
                prefix = "(byte) ";
            } else if (Short.class.equals(valueClass)) {
                prefix = "(short) ";
            }
            return prefix + format + appendix;
        }
        if (List.class.isAssignableFrom(valueClass)) {
            return this.generateListMethod((List)value, builder);
        }
        if (Map.class.isAssignableFrom(valueClass)) {
            return this.generateMapMethod((Map)value, builder);
        }
        throw new UnsupportedOperationException("Configuration map contains an entry of type " + valueClass + " which is not supported yet. Please file a bug report.");
    }

    private String generateListMethod(List<?> value, TypeSpec.Builder builder) {
        String methodName = "list" + this.methodCount++;
        MethodSpec.Builder listMethod = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).returns(List.class);
        if (value.isEmpty()) {
            listMethod.addStatement("return $.emptyList()", new Object[]{Collections.class});
        } else if (value.size() == 1) {
            listMethod.addStatement("return $T.singletonList($L)", new Object[]{Collections.class, this.convertValueToSource(value.get(0), builder)});
        } else {
            listMethod.addStatement("$T result = new $T<>($L)", new Object[]{List.class, ArrayList.class, value.size()});
            for (Object o : value) {
                listMethod.addStatement("result.add(" + this.convertValueToSource(o, builder) + ")", new Object[0]);
            }
            listMethod.addStatement("return result", new Object[0]);
        }
        builder.addMethod(listMethod.build());
        return methodName + "()";
    }

    private String generateMapMethod(Map<?, ?> value, TypeSpec.Builder builder) {
        String methodName = "map" + this.methodCount++;
        MethodSpec.Builder mapMethod = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).returns(Map.class);
        if (value.isEmpty()) {
            mapMethod.addStatement("return $.emptyMap()", new Object[]{Collections.class});
        } else if (value.size() == 1) {
            Map.Entry<?, ?> entry = value.entrySet().iterator().next();
            mapMethod.addStatement("return $T.singletonMap($L, $L)", new Object[]{Collections.class, this.convertValueToSource(entry.getKey(), builder), this.convertValueToSource(entry.getValue(), builder)});
        } else {
            mapMethod.addStatement("$T result = new $T<>($L)", new Object[]{Map.class, LinkedHashMap.class, value.size()});
            for (Map.Entry<?, ?> entry : value.entrySet()) {
                mapMethod.addStatement("result.put(" + this.convertValueToSource(entry.getKey(), builder) + ", " + this.convertValueToSource(entry.getValue(), builder) + ")", new Object[0]);
            }
            mapMethod.addStatement("return result", new Object[0]);
        }
        builder.addMethod(mapMethod.build());
        return methodName + "()";
    }

    @NonNull
    protected JavaFile generate() {
        String typeName = this.computeTypeName();
        String orderKey = "map.property.order." + this.resourceName;
        int order = (Integer)this.getContext().getConfiguration().optionalValue(orderKey, value -> value.map(Integer::parseInt).orElse(Integer.MIN_VALUE));
        TypeSpec.Builder typeBuilder = TypeSpec.classBuilder((String)typeName).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass(MapPropertySource.class);
        typeBuilder.addMethod(MethodSpec.constructorBuilder().addStatement("super($S, $L)", new Object[]{this.resourceName, this.generateMap(typeBuilder)}).build()).addMethod(MethodSpec.methodBuilder((String)"getOrder").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE).addStatement("return $L", new Object[]{order}).build()).addAnnotation(Generated.class);
        return this.javaFile(typeBuilder.build());
    }

    private String computeTypeName() {
        return StringUtils.capitalize((String)(this.resourceName.replaceAll("[^A-Za-z0-9]", "_") + "StaticPropertySource"));
    }
}

