/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aot.std.sourcegen;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import io.micronaut.aot.core.AOTContext;
import io.micronaut.aot.core.AOTModule;
import io.micronaut.aot.core.codegen.AbstractCodeGenerator;
import io.micronaut.context.env.CachedEnvironment;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.util.EnvironmentProperties;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@AOTModule(id="precompute.environment.properties", description="Precomputes Micronaut configuration property keys from the current environment variables")
public class EnvironmentPropertiesSourceGenerator
extends AbstractCodeGenerator {
    public static final String ID = "precompute.environment.properties";
    public static final String DESCRIPTION = "Precomputes Micronaut configuration property keys from the current environment variables";
    private final Map<String, String> env;

    public EnvironmentPropertiesSourceGenerator(Map<String, String> env) {
        this.env = env;
    }

    public EnvironmentPropertiesSourceGenerator() {
        this(CachedEnvironment.getenv());
    }

    public void generate(@NonNull AOTContext context) {
        context.registerStaticOptimization("EnvironmentPropertiesOptimizationLoader", EnvironmentProperties.class, initializer -> {
            EnvironmentProperties props = EnvironmentProperties.empty();
            this.env.keySet().forEach(arg_0 -> ((EnvironmentProperties)props).findPropertyNamesForEnvironmentVariable(arg_0));
            initializer.addStatement("$T env = new $T()", new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{ClassName.get(String.class), ParameterizedTypeName.get(List.class, (Type[])new Type[]{String.class})}), ParameterizedTypeName.get((ClassName)ClassName.get(HashMap.class), (TypeName[])new TypeName[]{ClassName.get(String.class), ParameterizedTypeName.get(List.class, (Type[])new Type[]{String.class})})});
            for (Map.Entry entry : props.asMap().entrySet()) {
                String values = ((List)entry.getValue()).stream().map(e -> "\"" + e + "\"").collect(Collectors.joining(", "));
                initializer.addStatement("env.put($S, $T.asList($L))", new Object[]{entry.getKey(), Arrays.class, values});
            }
            initializer.addStatement("return $T.of(env)", new Object[]{EnvironmentProperties.class});
        });
    }
}

