/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aot.std.sourcegen;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.model.ConfigurationModel;
import ch.qos.logback.classic.model.LoggerModel;
import ch.qos.logback.classic.model.RootLoggerModel;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.event.SaxEventRecorder;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.joran.util.beans.BeanDescription;
import ch.qos.logback.core.joran.util.beans.BeanDescriptionCache;
import ch.qos.logback.core.model.AppenderModel;
import ch.qos.logback.core.model.AppenderRefModel;
import ch.qos.logback.core.model.ComponentModel;
import ch.qos.logback.core.model.ImplicitModel;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.NamedComponentModel;
import ch.qos.logback.core.net.ssl.KeyManagerFactoryFactoryBean;
import ch.qos.logback.core.net.ssl.KeyStoreFactoryBean;
import ch.qos.logback.core.net.ssl.SSLConfiguration;
import ch.qos.logback.core.net.ssl.SSLParametersConfiguration;
import ch.qos.logback.core.net.ssl.SecureRandomFactoryBean;
import ch.qos.logback.core.net.ssl.TrustManagerFactoryFactoryBean;
import ch.qos.logback.core.spi.ContextAware;
import ch.qos.logback.core.spi.LifeCycle;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import io.micronaut.aot.core.AOTContext;
import io.micronaut.aot.std.sourcegen.ParentTagTagClassTuple;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import org.xml.sax.InputSource;

class Logback13GeneratorHelper {
    private static final List<ParentTagTagClassTuple> TUPLE_LIST = Logback13GeneratorHelper.createTuplesList();

    Logback13GeneratorHelper() {
    }

    private static List<ParentTagTagClassTuple> createTuplesList() {
        ArrayList<ParentTagTagClassTuple> tupleList = new ArrayList<ParentTagTagClassTuple>(9);
        tupleList.add(new ParentTagTagClassTuple("appender", "encoder", PatternLayoutEncoder.class));
        tupleList.add(new ParentTagTagClassTuple("appender", "layout", PatternLayout.class));
        tupleList.add(new ParentTagTagClassTuple("receiver", "ssl", SSLConfiguration.class));
        tupleList.add(new ParentTagTagClassTuple("ssl", "parameters", SSLParametersConfiguration.class));
        tupleList.add(new ParentTagTagClassTuple("ssl", "keyStore", KeyStoreFactoryBean.class));
        tupleList.add(new ParentTagTagClassTuple("ssl", "trustStore", KeyManagerFactoryFactoryBean.class));
        tupleList.add(new ParentTagTagClassTuple("ssl", "keyManagerFactory", SSLParametersConfiguration.class));
        tupleList.add(new ParentTagTagClassTuple("ssl", "trustManagerFactory", TrustManagerFactoryFactoryBean.class));
        tupleList.add(new ParentTagTagClassTuple("ssl", "secureRandom", SecureRandomFactoryBean.class));
        return Collections.unmodifiableList(tupleList);
    }

    private static void injectDefaultComponentClasses(Model aModel, Model parent) {
        Logback13GeneratorHelper.applyInjectionRules(aModel, parent);
        for (Model sub : aModel.getSubModels()) {
            Logback13GeneratorHelper.injectDefaultComponentClasses(sub, aModel);
        }
    }

    private static String unifiedTag(Model aModel) {
        String tag = aModel.getTag();
        char first = tag.charAt(0);
        if (Character.isUpperCase(first)) {
            char lower = Character.toLowerCase(first);
            return lower + tag.substring(1);
        }
        return tag;
    }

    private static void applyInjectionRules(Model aModel, Model parent) {
        ImplicitModel implicitModel;
        String className;
        if (parent == null) {
            return;
        }
        String parentTag = Logback13GeneratorHelper.unifiedTag(parent);
        String modelTag = Logback13GeneratorHelper.unifiedTag(aModel);
        if (aModel instanceof ImplicitModel && ((className = (implicitModel = (ImplicitModel)aModel).getClassName()) == null || className.isEmpty())) {
            for (ParentTagTagClassTuple ruleTuple : TUPLE_LIST) {
                if (!ruleTuple.parentTag.equals(parentTag) || !ruleTuple.tag.equals(modelTag)) continue;
                implicitModel.setClassName(ruleTuple.aClass.getName());
                break;
            }
        }
    }

    static MethodSpec configureMethod(String fileName, AOTContext aotContext) {
        Model model;
        JoranConfigurator joranConfigurator = new JoranConfigurator();
        LoggerContext context = new LoggerContext();
        joranConfigurator.setContext((Context)context);
        try {
            URL logbackFile = aotContext.getAnalyzer().getApplicationContext().getClass().getClassLoader().getResource(fileName);
            if (logbackFile == null) {
                throw new IllegalStateException("Could not find " + fileName + " file on application classpath");
            }
            InputSource inputSource = new InputSource(logbackFile.openStream());
            SaxEventRecorder recorder = joranConfigurator.populateSaxEventRecorder(inputSource);
            model = joranConfigurator.buildModelFromSaxEventList(recorder.saxEventList);
            Logback13GeneratorHelper.injectDefaultComponentClasses(model, null);
        }
        catch (JoranException | IOException e) {
            throw new RuntimeException(e);
        }
        final CodeBlock.Builder codeBuilder = CodeBlock.builder();
        final BeanDescriptionCache beanDescriptionCache = new BeanDescriptionCache((Context)context);
        ModelVisitor visitor = new ModelVisitor(){
            private final Map<String, Set<String>> loggerToAppenders = new HashMap<String, Set<String>>();
            private final Map<String, String> appenderRefToAppenderVarName = new HashMap<String, String>();
            private final Map<Model, String> modelToVarName = new HashMap<Model, String>();

            private String varNameOf(Model model) {
                return this.modelToVarName.computeIfAbsent(model, m -> {
                    String var = this.toVarName(model);
                    if (this.modelToVarName.containsValue(var)) {
                        var = this.toVarName(model) + "_" + this.modelToVarName.size();
                    }
                    return var;
                });
            }

            private String toVarName(Model model) {
                String name = model instanceof NamedComponentModel ? ((NamedComponentModel)model).getName() : (model instanceof LoggerModel ? ((LoggerModel)model).getName() : model.getTag());
                return name.replaceAll("[^a-zA-Z0-9]", "_").toLowerCase(Locale.US);
            }

            @Override
            public void visitRootLogger(RootLoggerModel model, Model parent) {
                codeBuilder.addStatement("$T _rootLogger = loggerContext.getLogger($T.ROOT_LOGGER_NAME)", new Object[]{Logger.class, Logger.class});
                String level = model.getLevel();
                if (level != null) {
                    codeBuilder.addStatement("_rootLogger.setLevel($T.$L)", new Object[]{ClassName.get(Level.class), Level.toLevel((String)level)});
                }
                this.collectAppenders((Model)model, "_rootLogger");
            }

            @Override
            public void visitLogger(LoggerModel model, Model parent) {
                String additivity;
                String loggerVarName = this.varNameOf((Model)model);
                codeBuilder.addStatement("$T $L = loggerContext.getLogger($S)", new Object[]{Logger.class, loggerVarName, model.getName()});
                String level = model.getLevel();
                if (level != null) {
                    codeBuilder.addStatement("$L.setLevel($T.$L)", new Object[]{loggerVarName, ClassName.get(Level.class), Level.toLevel((String)level)});
                }
                if ((additivity = model.getAdditivity()) != null) {
                    codeBuilder.addStatement("$L.setAdditive($L)", new Object[]{loggerVarName, Boolean.valueOf(additivity)});
                }
                this.collectAppenders((Model)model, loggerVarName);
            }

            private void collectAppenders(Model model, String loggerVarName) {
                Set appenders = model.getSubModels().stream().filter(AppenderRefModel.class::isInstance).map(AppenderRefModel.class::cast).map(AppenderRefModel::getRef).collect(Collectors.toSet());
                this.loggerToAppenders.put(loggerVarName, appenders);
            }

            @Override
            public void visitAppender(AppenderModel model, Model parent) {
                ClassName appenderName = ClassName.bestGuess((String)model.getClassName());
                String varName = this.varNameOf((Model)model);
                this.appenderRefToAppenderVarName.put(model.getName(), varName);
                codeBuilder.addStatement("$T $L = new $T()", new Object[]{appenderName, varName, appenderName});
            }

            @Override
            public void visitImplicit(ImplicitModel model, Model parent) {
                String className = model.getClassName();
                if (className == null && parent instanceof ComponentModel) {
                    this.generateSetterCode(model, parent);
                } else if (className != null) {
                    String varName = this.varNameOf((Model)model);
                    ClassName elementType = ClassName.bestGuess((String)className);
                    codeBuilder.addStatement("$T $L = new $T()", new Object[]{elementType, varName, elementType});
                }
            }

            @Override
            public void postVisitImplicit(ImplicitModel model, Model parent) {
                String className = model.getClassName();
                if (className != null) {
                    this.generateSetterCode(model, parent);
                }
            }

            @Override
            public void postVisit(Model model, Model parent) {
                String className;
                if (model instanceof ComponentModel && (className = ((ComponentModel)model).getClassName()) != null) {
                    try {
                        Class<?> clazz = Class.forName(className);
                        if (ContextAware.class.isAssignableFrom(clazz)) {
                            codeBuilder.addStatement("$L.setContext(context)", new Object[]{this.varNameOf(model)});
                        }
                        if (LifeCycle.class.isAssignableFrom(clazz)) {
                            codeBuilder.addStatement("$L.start()", new Object[]{this.varNameOf(model)});
                        }
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                }
                ModelVisitor.super.postVisit(model, parent);
            }

            private void generateSetterCode(ImplicitModel model, Model parent) {
                if (!this.maybeGenerateAddOrSet(model, parent, BeanDescription::getSetter)) {
                    this.maybeGenerateAddOrSet(model, parent, BeanDescription::getAdder);
                }
            }

            private boolean maybeGenerateAddOrSet(ImplicitModel model, Model parent, BiFunction<BeanDescription, String, Method> methodFinder) {
                try {
                    String ownerClassName = ((ComponentModel)parent).getClassName();
                    BeanDescription beanDescription = beanDescriptionCache.getBeanDescription(Class.forName(ownerClassName));
                    Method method = methodFinder.apply(beanDescription, model.getTag());
                    if (method != null) {
                        Class<?> parameterType = method.getParameterTypes()[0];
                        String parentVarName = this.varNameOf(parent);
                        if (model.getBodyText() == null) {
                            codeBuilder.addStatement("$L.$L($L)", new Object[]{parentVarName, method.getName(), this.varNameOf((Model)model)});
                            return true;
                        }
                        if (parameterType.isPrimitive()) {
                            Object value = this.toPrimitiveValue(model, parameterType);
                            codeBuilder.addStatement("$L.$L($L)", new Object[]{parentVarName, method.getName(), value});
                            return true;
                        }
                        if (String.class.equals(parameterType)) {
                            codeBuilder.addStatement("$L.$L($S)", new Object[]{parentVarName, method.getName(), model.getBodyText()});
                            return true;
                        }
                        try {
                            Method valueOf = parameterType.getDeclaredMethod("valueOf", String.class);
                            codeBuilder.addStatement("$L.$L($T.valueOf($S))", new Object[]{parentVarName, method.getName(), ClassName.get(parameterType), model.getBodyText()});
                            return true;
                        }
                        catch (NoSuchMethodException e) {
                            throw new RuntimeException("Unable to convert type" + parameterType);
                        }
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
                return false;
            }

            private Object toPrimitiveValue(ImplicitModel model, Class<?> parameterType) {
                String bodyText = model.getBodyText();
                Object value = parameterType.equals(Boolean.TYPE) ? Boolean.valueOf(bodyText) : (parameterType.equals(Byte.TYPE) ? Byte.valueOf(bodyText) : (parameterType.equals(Character.TYPE) ? Character.valueOf(bodyText.charAt(0)) : (parameterType.equals(Double.TYPE) ? Double.valueOf(bodyText) : (parameterType.equals(Float.TYPE) ? Float.valueOf(bodyText) : (parameterType.equals(Integer.TYPE) ? Integer.valueOf(bodyText) : (parameterType.equals(Long.TYPE) ? Long.valueOf(bodyText) : (parameterType.equals(Short.TYPE) ? Short.valueOf(bodyText) : bodyText)))))));
                return value;
            }

            @Override
            public void postVisitConfiguration(ConfigurationModel model, Model parent) {
                for (Map.Entry<String, Set<String>> entry : this.loggerToAppenders.entrySet()) {
                    String loggerName = entry.getKey();
                    for (String appenderRef : entry.getValue()) {
                        String varName = this.appenderRefToAppenderVarName.get(appenderRef);
                        if (varName == null) continue;
                        codeBuilder.addStatement("$L.addAppender($L)", new Object[]{loggerName, varName});
                    }
                }
            }
        };
        visitor.visit(model);
        return MethodSpec.methodBuilder((String)"configure").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(LoggerContext.class, "loggerContext", new Modifier[0]).addCode(codeBuilder.build()).build();
    }

    static interface ModelVisitor {
        default public void visit(Model model) {
            this.visit(model, null);
        }

        default public void visit(Model model, Model parent) {
            this.previsit(model, parent);
            model.getSubModels().forEach(m -> this.visit((Model)m, model));
            this.postVisit(model, parent);
        }

        default public void previsit(Model model, Model parent) {
            if (model instanceof RootLoggerModel) {
                this.visitRootLogger((RootLoggerModel)model, parent);
            }
            if (model instanceof AppenderModel) {
                this.visitAppender((AppenderModel)model, parent);
            }
            if (model instanceof ImplicitModel) {
                this.visitImplicit((ImplicitModel)model, parent);
            }
            if (model instanceof LoggerModel) {
                this.visitLogger((LoggerModel)model, parent);
            }
            if (model instanceof ConfigurationModel) {
                this.visitConfiguration((ConfigurationModel)model, parent);
            }
        }

        default public void visitConfiguration(ConfigurationModel model, Model parent) {
        }

        default public void postVisitConfiguration(ConfigurationModel model, Model parent) {
        }

        default public void postVisit(Model model, Model parent) {
            if (model instanceof RootLoggerModel) {
                this.postVisitRootLogger((RootLoggerModel)model, parent);
            }
            if (model instanceof AppenderModel) {
                this.postVisitAppender((AppenderModel)model, parent);
            }
            if (model instanceof ImplicitModel) {
                this.postVisitImplicit((ImplicitModel)model, parent);
            }
            if (model instanceof LoggerModel) {
                this.postVisitLogger((LoggerModel)model, parent);
            }
            if (model instanceof ConfigurationModel) {
                this.postVisitConfiguration((ConfigurationModel)model, parent);
            }
        }

        default public void visitRootLogger(RootLoggerModel model, Model parent) {
        }

        default public void postVisitRootLogger(RootLoggerModel model, Model parent) {
        }

        default public void visitLogger(LoggerModel model, Model parent) {
        }

        default public void postVisitLogger(LoggerModel model, Model parent) {
        }

        default public void visitAppender(AppenderModel model, Model parent) {
        }

        default public void postVisitAppender(AppenderModel model, Model parent) {
        }

        default public void visitImplicit(ImplicitModel model, Model parent) {
        }

        default public void postVisitImplicit(ImplicitModel model, Model parent) {
        }
    }
}

