/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aot.std.sourcegen;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import io.micronaut.aot.core.AOTContext;
import io.micronaut.aot.core.AOTModule;
import io.micronaut.aot.core.codegen.AbstractCodeGenerator;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.async.publisher.PublishersOptimizations;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

@AOTModule(id="scan.reactive.types", description="Scans reactive types at build time instead of runtime")
public class PublishersSourceGenerator
extends AbstractCodeGenerator {
    public static final String ID = "scan.reactive.types";
    public static final String DESCRIPTION = "Scans reactive types at build time instead of runtime";

    public void generate(@NonNull AOTContext context) {
        context.registerStaticOptimization("PublishersOptimizationsLoader", PublishersOptimizations.class, body -> {
            List<String> knownReactiveTypes = PublishersSourceGenerator.typeNamesOf(Publishers.getKnownReactiveTypes());
            List<String> knownSingleTypes = PublishersSourceGenerator.typeNamesOf(Publishers.getKnownSingleTypes());
            List<String> knownCompletableTypes = PublishersSourceGenerator.typeNamesOf(Publishers.getKnownCompletableTypes());
            body.addStatement("return new $T($L, $L, $L)", new Object[]{PublishersOptimizations.class, PublishersSourceGenerator.asClassList(knownReactiveTypes), PublishersSourceGenerator.asClassList(knownSingleTypes), PublishersSourceGenerator.asClassList(knownCompletableTypes)});
        });
    }

    private static CodeBlock asClassList(List<String> types) {
        CodeBlock.Builder knownReactiveBlock = CodeBlock.builder().add("$T.asList(", new Object[]{Arrays.class});
        for (int i = 0; i < types.size(); ++i) {
            String knownReactiveType = types.get(i);
            knownReactiveBlock.add("$T.class", new Object[]{ClassName.bestGuess((String)knownReactiveType.replace('$', '.'))});
            if (i >= types.size() - 1) continue;
            knownReactiveBlock.add(", ", new Object[0]);
        }
        knownReactiveBlock.add(")", new Object[0]);
        return knownReactiveBlock.build();
    }

    private static List<String> typeNamesOf(Collection<Class<?>> classes) {
        return classes.stream().map(Class::getName).collect(Collectors.toList());
    }
}

