/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aot.std.sourcegen;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import io.micronaut.aot.core.AOTCodeGenerator;
import io.micronaut.aot.core.AOTContext;
import io.micronaut.aot.core.Runtime;
import io.micronaut.aot.core.codegen.AbstractCodeGenerator;
import io.micronaut.aot.core.codegen.DelegatingSourceGenerationContext;
import io.micronaut.aot.core.config.MetadataUtils;
import io.micronaut.aot.std.sourcegen.YamlPropertySourceGenerator;
import io.micronaut.context.env.PropertySourceLoader;
import io.micronaut.context.env.yaml.YamlPropertySourceLoader;
import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.annotation.Generated;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.io.service.SoftServiceLoader;
import io.micronaut.inject.BeanConfiguration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStaticServiceLoaderSourceGenerator
extends AbstractCodeGenerator {
    public static final String SERVICE_LOADING_CATEGORY = "serviceloading";
    public static final String DESCRIPTION = "Scans for service types ahead-of-time, avoiding classpath scanning at startup";
    public static final String SERVICE_TYPES = "service.types";
    public static final String REJECTED_CLASSES = "serviceloading.rejected.impls";
    public static final String FORCE_INCLUDE = "serviceloading.force.include.impls";
    protected static final String DEFAULT_SERVICE_TYPES = "io.micronaut.context.env.PropertySourceLoader,io.micronaut.inject.BeanConfiguration,io.micronaut.inject.BeanDefinitionReference,io.micronaut.http.HttpRequestFactory,io.micronaut.http.HttpResponseFactory,io.micronaut.core.beans.BeanIntrospectionReference";
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractStaticServiceLoaderSourceGenerator.class);
    protected AOTContext context;
    private Predicate<AnnotationMetadataProvider> metadataProviderPredicate;
    private List<String> serviceNames;
    private Predicate<String> rejectedClasses;
    private Map<String, AbstractCodeGenerator> substitutions;
    private Set<String> forceInclude;
    private final Substitutes substitutes = new Substitutes();
    private final Map<String, TypeSpec> staticServiceClasses = new HashMap<String, TypeSpec>();
    private final Set<BeanConfiguration> disabledConfigurations = Collections.synchronizedSet(new HashSet());
    private final Map<String, List<Class<?>>> serviceClasses = new HashMap();
    private final Set<Class<?>> disabledServices = new HashSet();

    public void generate(@NonNull AOTContext context) {
        this.context = context;
        if (this.serviceNames == null) {
            this.serviceNames = context.getConfiguration().stringList(MetadataUtils.findOption(((Object)((Object)this)).getClass(), (String)SERVICE_TYPES).key());
        }
        if (this.substitutions == null) {
            LinkedHashSet<String> resourceNames = new LinkedHashSet<String>();
            resourceNames.add("application");
            context.getAnalyzer().getEnvironmentNames().stream().map(env -> "application-" + env).forEach(resourceNames::add);
            context.getConfiguration().stringList("possible.environments").stream().filter(env -> !"default".equals(env)).map(env -> "application-" + env).forEach(resourceNames::add);
            this.substitutions = new HashMap<String, AbstractCodeGenerator>();
            if (context.getConfiguration().isFeatureEnabled("yaml.to.java.config")) {
                YamlPropertySourceGenerator yaml = new YamlPropertySourceGenerator(resourceNames);
                yaml.generate(context);
                if (MetadataUtils.isEnabledOn((Runtime)context.getRuntime(), (AOTCodeGenerator)yaml)) {
                    LOGGER.debug("Substituting {} with {}", (Object)PropertySourceLoader.class.getName(), (Object)((Object)((Object)yaml)).getClass().getName());
                    this.substitutions.put(YamlPropertySourceLoader.class.getName(), yaml);
                }
            }
        }
        if (this.metadataProviderPredicate == null) {
            this.metadataProviderPredicate = context.getAnalyzer().getAnnotationMetadataPredicate();
        }
        if (this.rejectedClasses == null) {
            List strings = context.getConfiguration().stringList(MetadataUtils.findOption(((Object)((Object)this)).getClass(), (String)REJECTED_CLASSES).key());
            HashSet rejected = strings.isEmpty() ? Collections.emptySet() : new HashSet(strings);
            this.rejectedClasses = rejected::contains;
        }
        if (this.forceInclude == null) {
            this.forceInclude = new HashSet<String>(context.getConfiguration().stringList(MetadataUtils.findOption(((Object)((Object)this)).getClass(), (String)FORCE_INCLUDE).key()));
        }
        for (String serviceName : this.serviceNames) {
            LOGGER.debug("Processing service type {}", (Object)serviceName);
            this.collectServiceImplementations(serviceName);
        }
        context.put(Substitutes.class, (Object)this.substitutes);
        for (BeanConfiguration beanConfiguration : this.disabledConfigurations) {
            for (List<Class<?>> classList : this.serviceClasses.values()) {
                for (Class<?> clazz : classList) {
                    if (!beanConfiguration.isWithin(clazz)) continue;
                    context.addDiagnostics(SERVICE_LOADING_CATEGORY, "Disabling " + clazz.getName() + " because it belongs to " + beanConfiguration.getName() + " which is disabled (" + beanConfiguration.getClass() + ")");
                    this.disabledServices.add(clazz);
                }
            }
        }
        this.generateServiceLoader();
        LOGGER.debug("Generated static service loader classes: {}", this.staticServiceClasses.keySet());
        LOGGER.debug("Generated static {} service loader substitutions", (Object)this.substitutes.values().size());
        this.staticServiceClasses.values().stream().map(arg_0 -> ((AOTContext)context).javaFile(arg_0)).forEach(arg_0 -> ((AOTContext)context).registerGeneratedSourceFile(arg_0));
        context.registerStaticOptimization("StaticServicesLoader", SoftServiceLoader.Optimizations.class, this::buildOptimization);
    }

    private void generateServiceLoader() {
        for (Map.Entry<String, List<Class<?>>> services : this.serviceClasses.entrySet()) {
            Class<?> serviceType;
            String serviceName = services.getKey();
            List<Class<?>> implementations = services.getValue();
            try {
                serviceType = ((Object)((Object)this)).getClass().getClassLoader().loadClass(serviceName);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            TypeSpec.Builder factory = this.prepareServiceLoaderType(serviceName, serviceType);
            this.generateFindAllMethod(implementations.stream().filter(clazz -> !this.rejectedClasses.test(clazz.getName()) && !this.disabledServices.contains(clazz)), serviceName, serviceType, factory);
            this.staticServiceClasses.put(serviceName, factory.build());
        }
    }

    private void collectServiceImplementations(String serviceName) {
        this.context.addDiagnostics(SERVICE_LOADING_CATEGORY, "Starting service discovery for type " + serviceName);
        ClassLoader cl = ((Object)((Object)this)).getClass().getClassLoader();
        Set seen = Collections.synchronizedSet(new HashSet());
        SoftServiceLoader.ServiceCollector availableClasses = SoftServiceLoader.newCollector((String)serviceName, s -> !s.isEmpty(), (ClassLoader)cl, className -> {
            Class<?> clazz;
            if (this.rejectedClasses.test((String)className) || !seen.add(className)) {
                return null;
            }
            AbstractCodeGenerator substitution = this.substitutions.get(className);
            if (substitution != null) {
                final ArrayList javaFiles = new ArrayList();
                DelegatingSourceGenerationContext tracker = new DelegatingSourceGenerationContext(this.context){

                    public void registerGeneratedSourceFile(@NonNull JavaFile javaFile) {
                        super.registerGeneratedSourceFile(javaFile);
                        javaFiles.add(javaFile);
                    }
                };
                substitution.generate((AOTContext)tracker);
                javaFiles.forEach(substitute -> this.substitutes.computeIfAbsent(serviceName, k -> new ArrayList()).add((JavaFile)substitute));
                if (!javaFiles.isEmpty()) {
                    return null;
                }
            }
            try {
                clazz = cl.loadClass((String)className);
                DeepAnalyzer deepAnalyzer = this.deepAnalyzerFor(clazz, serviceName);
                boolean available = deepAnalyzer.isAvailable(clazz);
                if (!available && this.forceInclude.contains(className)) {
                    this.context.addDiagnostics(SERVICE_LOADING_CATEGORY, "Forcing inclusion of " + clazz + " despite it not matching bean requirements");
                    available = true;
                }
                if (!available) {
                    if (BeanConfiguration.class.isAssignableFrom(clazz)) {
                        this.disabledConfigurations.add((BeanConfiguration)clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
                    }
                    this.context.addDiagnostics(SERVICE_LOADING_CATEGORY, "Skipping " + clazz + " because it doesn't match bean requirements");
                    return null;
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoClassDefFoundError | NoSuchMethodException | InvocationTargetException e) {
                this.context.addDiagnostics(SERVICE_LOADING_CATEGORY, "Skipping service " + serviceName + " implementation " + className + " because of missing dependencies: " + e.getMessage());
                return null;
            }
            return clazz;
        });
        ArrayList serviceClasses = new ArrayList();
        availableClasses.collect(serviceClasses::add);
        this.serviceClasses.put(serviceName, serviceClasses);
    }

    private DeepAnalyzer deepAnalyzerFor(Class<?> clazz, String serviceName) throws ClassNotFoundException {
        if (AnnotationMetadataProvider.class.isAssignableFrom(clazz)) {
            return new AnnotationMetadataAnalyzer(this.context, this.metadataProviderPredicate, serviceName);
        }
        return DeepAnalyzer.DEFAULT;
    }

    protected abstract void generateFindAllMethod(Stream<Class<?>> var1, String var2, Class<?> var3, TypeSpec.Builder var4);

    private TypeSpec.Builder prepareServiceLoaderType(String serviceName, Class<?> serviceType) {
        String name = AbstractStaticServiceLoaderSourceGenerator.simpleNameOf((String)serviceName) + "Factory";
        TypeSpec.Builder factory = TypeSpec.classBuilder((String)name).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Generated.class).addSuperinterface((TypeName)ParameterizedTypeName.get(SoftServiceLoader.StaticServiceLoader.class, (Type[])new Type[]{serviceType}));
        return factory;
    }

    private void buildOptimization(CodeBlock.Builder body) {
        ParameterizedTypeName serviceLoaderType = ParameterizedTypeName.get((ClassName)ClassName.get(SoftServiceLoader.StaticServiceLoader.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(Object.class)});
        body.addStatement("$T staticServices = new $T()", new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{ClassName.get(String.class), serviceLoaderType}), ParameterizedTypeName.get((ClassName)ClassName.get(HashMap.class), (TypeName[])new TypeName[]{ClassName.get(String.class), serviceLoaderType})});
        for (Map.Entry<String, TypeSpec> entry : this.staticServiceClasses.entrySet()) {
            body.addStatement("staticServices.put($S, new $T())", new Object[]{entry.getKey(), ClassName.bestGuess((String)entry.getValue().name)});
        }
        body.addStatement("return new $T(staticServices)", new Object[]{SoftServiceLoader.Optimizations.class});
    }

    static final class Substitutes {
        private final Map<String, List<JavaFile>> substitutes = new HashMap<String, List<JavaFile>>();

        Substitutes() {
        }

        private Collection<List<JavaFile>> values() {
            return this.substitutes.values();
        }

        void putAll(Map<String, List<JavaFile>> substitutes) {
            this.substitutes.putAll(substitutes);
        }

        private List<JavaFile> computeIfAbsent(String key, Function<? super String, ? extends List<JavaFile>> mappingFunction) {
            return this.substitutes.computeIfAbsent(key, mappingFunction);
        }

        public List<JavaFile> findSubstitutesFor(String serviceType) {
            return this.substitutes.getOrDefault(serviceType, Collections.emptyList());
        }
    }

    private static final class AnnotationMetadataAnalyzer
    implements DeepAnalyzer {
        private final AOTContext context;
        private final Predicate<AnnotationMetadataProvider> predicate;
        private final String serviceName;

        private AnnotationMetadataAnalyzer(AOTContext context, Predicate<AnnotationMetadataProvider> predicate, String serviceName) {
            this.context = context;
            this.predicate = predicate;
            this.serviceName = serviceName;
        }

        @Override
        public boolean isAvailable(Class<?> clazz) {
            try {
                AnnotationMetadataProvider reference = (AnnotationMetadataProvider)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                return this.predicate.test(reference);
            }
            catch (Throwable e) {
                return this.skipService(clazz, e);
            }
        }

        private boolean skipService(Class<?> clazz, Throwable e) {
            this.context.addDiagnostics(AbstractStaticServiceLoaderSourceGenerator.SERVICE_LOADING_CATEGORY, "Skipping service " + this.serviceName + " implementation " + clazz.getName() + " because of missing dependencies:" + e.getMessage());
            return false;
        }
    }

    static interface DeepAnalyzer {
        public static final DeepAnalyzer DEFAULT = new DeepAnalyzer(){};

        default public boolean isAvailable(Class<?> clazz) {
            return true;
        }
    }
}

