/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aot.std.sourcegen;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import io.micronaut.aot.core.AOTModule;
import io.micronaut.aot.core.Option;
import io.micronaut.aot.core.Runtime;
import io.micronaut.aot.std.sourcegen.AbstractStaticServiceLoaderSourceGenerator;
import io.micronaut.aot.std.sourcegen.YamlPropertySourceGenerator;
import io.micronaut.core.io.service.SoftServiceLoader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@AOTModule(id="serviceloading.native", description="Scans for service types ahead-of-time, avoiding classpath scanning at startup", options={@Option(key="service.types", description="The list of service types to be scanned (comma separated)", sampleValue="io.micronaut.context.env.PropertySourceLoader,io.micronaut.inject.BeanConfiguration,io.micronaut.inject.BeanDefinitionReference,io.micronaut.http.HttpRequestFactory,io.micronaut.http.HttpResponseFactory,io.micronaut.core.beans.BeanIntrospectionReference"), @Option(key="serviceloading.rejected.impls", description="A list of implementation types which shouldn't be included in the final application (comma separated)", sampleValue="com.Misc,org.Bar"), @Option(key="serviceloading.force.include.impls", description="A list of implementation types to include even if they don't match bean requirements (comma separated)", sampleValue="com.Misc,org.Bar"), @Option(key="possible.environments", description="The list of environment names that this application can possibly use at runtime.", sampleValue="dev,prod,aws,gcs")}, enabledOn={Runtime.NATIVE}, subgenerators={YamlPropertySourceGenerator.class})
public class NativeStaticServiceLoaderSourceGenerator
extends AbstractStaticServiceLoaderSourceGenerator {
    public static final String ID = "serviceloading.native";

    @Override
    protected final void generateFindAllMethod(Stream<Class<?>> serviceClasses, String serviceName, Class<?> serviceType, TypeSpec.Builder factory) {
        class Service {
            final String name;
            final CodeBlock codeBlock;

            Service(String name, CodeBlock codeBlock) {
                this.name = name;
                this.codeBlock = codeBlock;
            }
        }
        List initializers = serviceClasses.map(clazz -> {
            for (Method method : clazz.getDeclaredMethods()) {
                if (!"provider".equals(method.getName()) || !Modifier.isStatic(method.getModifiers())) continue;
                return new Service(clazz.getName(), CodeBlock.of((String)"$T::provider", (Object[])new Object[]{clazz}));
            }
            for (Executable executable : clazz.getDeclaredConstructors()) {
                if (((Constructor)executable).getParameterCount() != 0 || !Modifier.isPublic(((Constructor)executable).getModifiers())) continue;
                return new Service(clazz.getName(), CodeBlock.of((String)"$T::new", (Object[])new Object[]{clazz}));
            }
            return null;
        }).filter(Objects::nonNull).sorted(Comparator.comparing(s -> s.name)).collect(Collectors.toList());
        ParameterizedTypeName staticDefinitionType = ParameterizedTypeName.get(SoftServiceLoader.StaticDefinition.class, (Type[])new Type[]{serviceType});
        MethodSpec.Builder method = MethodSpec.methodBuilder((String)"findAll").addModifiers(new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PUBLIC}).addParameter((TypeName)ParameterizedTypeName.get(Predicate.class, (Type[])new Type[]{String.class}), "predicate", new javax.lang.model.element.Modifier[0]).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Stream.class), (TypeName[])new TypeName[]{staticDefinitionType}));
        if (initializers.size() == 0) {
            method.addStatement("return $T.empty()", new Object[]{Stream.class});
        } else {
            method.addStatement("$T list = new $T<>()", new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{staticDefinitionType}), ArrayList.class});
            for (Service initializer : initializers) {
                method.beginControlFlow("if (predicate.test($S))", new Object[]{initializer.name});
                method.addStatement("list.add($T.of($S, $L))", new Object[]{SoftServiceLoader.StaticDefinition.class, initializer.name, initializer.codeBlock});
                method.endControlFlow();
            }
            method.addStatement("return list.stream()", new Object[0]);
        }
        factory.addMethod(method.build());
    }
}

