/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aot.std.sourcegen;

import ch.qos.logback.classic.spi.Configurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.status.Status;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import io.micronaut.aot.core.AOTContext;
import io.micronaut.aot.core.AOTModule;
import io.micronaut.aot.core.codegen.AbstractSingleClassFileGenerator;
import io.micronaut.aot.std.sourcegen.Logback14GeneratorHelper;
import io.micronaut.core.annotation.NonNull;
import java.util.Locale;
import javax.lang.model.element.Modifier;

@AOTModule(id="logback.xml.to.java", description="Replaces logback.xml with a pure Java configuration (Experimental)")
public class LogbackConfigurationSourceGenerator
extends AbstractSingleClassFileGenerator {
    public static final String ID = "logback.xml.to.java";
    public static final String DESCRIPTION = "Replaces logback.xml with a pure Java configuration (Experimental)";

    @NonNull
    protected JavaFile generate() {
        try {
            Class.forName("ch.qos.logback.core.model.Model");
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("The logback.xml conversion feature requires logback 1.4 on the AOT optimizer classpath.");
        }
        TypeSpec typeSpec = TypeSpec.classBuilder((String)"StaticLogbackConfiguration").addModifiers(new Modifier[]{Modifier.PUBLIC}).addSuperinterface(Configurator.class).addField(LogbackConfigurationSourceGenerator.contextField()).addMethod(Logback14GeneratorHelper.configureMethod(this.getLogbackFileName(), this.getContext())).addMethod(LogbackConfigurationSourceGenerator.setContextMethod()).addMethod(LogbackConfigurationSourceGenerator.getContextMethod()).addMethod(LogbackConfigurationSourceGenerator.addStatusMethod()).addMethod(LogbackConfigurationSourceGenerator.addLogMethod("Info")).addMethod(LogbackConfigurationSourceGenerator.addLog2Method("Info")).addMethod(LogbackConfigurationSourceGenerator.addLogMethod("Warn")).addMethod(LogbackConfigurationSourceGenerator.addLog2Method("Warn")).addMethod(LogbackConfigurationSourceGenerator.addLogMethod("Error")).addMethod(LogbackConfigurationSourceGenerator.addLog2Method("Error")).build();
        return this.javaFile(typeSpec);
    }

    protected String getLogbackFileName() {
        return "logback.xml";
    }

    public void generate(@NonNull AOTContext context) {
        super.generate(context);
        context.registerExcludedResource(this.getLogbackFileName());
        context.registerServiceImplementation(Configurator.class, "StaticLogbackConfiguration");
    }

    private static MethodSpec addStatusMethod() {
        return MethodSpec.methodBuilder((String)"addStatus").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(Status.class, "status", new Modifier[0]).build();
    }

    private static MethodSpec addLogMethod(String name) {
        return MethodSpec.methodBuilder((String)("add" + name)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(String.class, name.toLowerCase(Locale.US), new Modifier[0]).build();
    }

    private static MethodSpec addLog2Method(String name) {
        return MethodSpec.methodBuilder((String)("add" + name)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(String.class, name.toLowerCase(Locale.US), new Modifier[0]).addParameter(Throwable.class, "ex", new Modifier[0]).build();
    }

    private static MethodSpec getContextMethod() {
        return MethodSpec.methodBuilder((String)"getContext").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Context.class).addStatement("return context", new Object[0]).build();
    }

    private static MethodSpec setContextMethod() {
        return MethodSpec.methodBuilder((String)"setContext").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(Context.class, "context", new Modifier[0]).addStatement("this.context = context", new Object[0]).build();
    }

    private static FieldSpec contextField() {
        return FieldSpec.builder(Context.class, (String)"context", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE}).build();
    }
}

