/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aot.std.sourcegen;

import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import io.micronaut.aot.core.AOTContext;
import io.micronaut.aot.core.AOTModule;
import io.micronaut.aot.core.codegen.AbstractCodeGenerator;
import io.micronaut.aot.core.context.ApplicationContextAnalyzer;
import io.micronaut.context.ApplicationContextBuilder;
import io.micronaut.context.ApplicationContextConfiguration;
import io.micronaut.context.ApplicationContextConfigurer;
import io.micronaut.context.BeanContextConfiguration;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;

@AOTModule(id="deduce.environment", description="Deduces the environment at build time instead of runtime")
public class DeduceEnvironmentSourceGenerator
extends AbstractCodeGenerator {
    public static final String ID = "deduce.environment";
    public static final String DESCRIPTION = "Deduces the environment at build time instead of runtime";
    public static final String DEDUCED_ENVIRONMENT_CONFIGURER = "DeducedEnvironmentConfigurer";

    public void generate(AOTContext context) {
        ApplicationContextConfiguration applicationContextConfiguration;
        boolean deduceEnvironments;
        ApplicationContextAnalyzer analyzer = context.getAnalyzer();
        Set environmentNames = analyzer.getEnvironmentNames();
        BeanContextConfiguration contextConfiguration = analyzer.getApplicationContext().getContextConfiguration();
        if (contextConfiguration instanceof ApplicationContextConfiguration && (deduceEnvironments = (applicationContextConfiguration = (ApplicationContextConfiguration)contextConfiguration).getDeduceEnvironments().orElse(true).booleanValue())) {
            Collection packages = analyzer.getApplicationContext().getEnvironment().getPackages();
            context.registerGeneratedSourceFile(context.javaFile(this.buildApplicationContextConfigurer(environmentNames, packages)));
            context.registerServiceImplementation(ApplicationContextConfigurer.class, DEDUCED_ENVIRONMENT_CONFIGURER);
        }
    }

    private TypeSpec buildApplicationContextConfigurer(Set<String> environmentNames, Collection<String> packages) {
        MethodSpec.Builder bodyBuilder = MethodSpec.methodBuilder((String)"configure").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(ApplicationContextBuilder.class, "builder", new Modifier[0]);
        bodyBuilder.addStatement("builder.deduceEnvironment(false)", new Object[0]);
        if (!environmentNames.isEmpty()) {
            bodyBuilder.addStatement("builder.defaultEnvironments($L)", new Object[]{DeduceEnvironmentSourceGenerator.toQuotedStringList(environmentNames)});
        }
        if (!packages.isEmpty()) {
            bodyBuilder.addStatement("builder.packages($L)", new Object[]{DeduceEnvironmentSourceGenerator.toQuotedStringList(packages)});
        }
        return TypeSpec.classBuilder((String)DEDUCED_ENVIRONMENT_CONFIGURER).addSuperinterface(ApplicationContextConfigurer.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addMethod(bodyBuilder.build()).addMethod(MethodSpec.methodBuilder((String)"getOrder").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(Integer.TYPE).addStatement("return LOWEST_PRECEDENCE", new Object[0]).build()).build();
    }

    private static String toQuotedStringList(Collection<String> elements) {
        return elements.stream().map(e -> "\"" + e + "\"").collect(Collectors.joining(", "));
    }
}

