/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aot.std.sourcegen;

import io.micronaut.aot.core.AOTContext;
import io.micronaut.aot.core.AOTModule;
import io.micronaut.aot.core.Option;
import io.micronaut.aot.core.codegen.AbstractCodeGenerator;
import io.micronaut.aot.core.config.MetadataUtils;
import io.micronaut.aot.std.sourcegen.MapPropertySourceGenerator;
import io.micronaut.context.env.ActiveEnvironment;
import io.micronaut.context.env.EmptyPropertySource;
import io.micronaut.context.env.MapPropertySource;
import io.micronaut.context.env.PropertySource;
import io.micronaut.context.env.PropertySourceLoader;
import io.micronaut.context.env.yaml.YamlPropertySourceLoader;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.io.ResourceLoader;
import io.micronaut.core.io.scan.DefaultClassPathResourceLoader;
import io.micronaut.core.util.StringUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AOTModule(id="property-source-loader.generate", description="Converts configuration files supplied by property source loaders to Java configuration", options={@Option(key="property-source-loader.types", description="The PropertySourceLoader classnames to use for generating property sources", sampleValue="io.micronaut.context.env.PropertiesPropertySourceLoader, io.micronaut.context.env.yaml.YamlPropertySourceLoader"), @Option(key="property-source-loader.base-order", description="The base order to use for the generated property sources. Positive value will be added to base order for specific environments", sampleValue="-1073741824"), @Option(key="property-source-loader.resource-names", description="The resource names to generate property sources for. By default, it is 'application,bootstrap'.", sampleValue="application,bootstrap"), @Option(key="property-source-loader.service-loader-exclude", description="Whether the property source loaders specified by types should be excluded in service loading", sampleValue="true"), @Option(key="yaml.to.java.config", description="Deprecated option to enable the yaml property source generation. Use property-source-loader.types=io.micronaut.context.env.yaml.YamlPropertySourceLoader instead", sampleValue="false")})
@Internal
public class GenericPropertySourceGenerator
extends AbstractCodeGenerator {
    public static final String ID = "property-source-loader.generate";
    public static final String DESCRIPTION = "Converts configuration files supplied by property source loaders to Java configuration";
    public static final Option TYPES_OPTION = ((AOTModule)MetadataUtils.findMetadata(GenericPropertySourceGenerator.class).get()).options()[0];
    public static final Option BASE_ORDER_OPTION = ((AOTModule)MetadataUtils.findMetadata(GenericPropertySourceGenerator.class).get()).options()[1];
    public static final Option RESOURCE_NAMES_OPTION = ((AOTModule)MetadataUtils.findMetadata(GenericPropertySourceGenerator.class).get()).options()[2];
    public static final Option SERVICE_LOADER_EXCLUDE_OPTION = ((AOTModule)MetadataUtils.findMetadata(GenericPropertySourceGenerator.class).get()).options()[3];
    public static final Option YAML_GENERATION_OPTION = ((AOTModule)MetadataUtils.findMetadata(GenericPropertySourceGenerator.class).get()).options()[4];
    public static final String YAML_PROPERTY_SOURCE_LOADER = YamlPropertySourceLoader.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger(GenericPropertySourceGenerator.class);
    private final List<String> resources;
    private final List<String> propertySourceLoaderTypes;
    private final int baseOrder;
    private final Collection<ActiveEnvironment> environments;
    private final boolean serviceLoaderExclude;

    public GenericPropertySourceGenerator(AOTContext context, Collection<ActiveEnvironment> environments) {
        List<String> resources = context.getConfiguration().stringList(RESOURCE_NAMES_OPTION.key());
        if (resources.isEmpty()) {
            resources = List.of("application", "bootstrap");
        }
        this.resources = resources;
        List propertySourceLoaderTypes = context.getConfiguration().stringList(TYPES_OPTION.key());
        if (context.getConfiguration().booleanValue(YAML_GENERATION_OPTION.key(), false)) {
            LOG.warn("Option {} is deprecated. Automatically using {}={} instead.", new Object[]{YAML_GENERATION_OPTION, TYPES_OPTION.key(), YAML_PROPERTY_SOURCE_LOADER});
            if (!propertySourceLoaderTypes.contains(YAML_PROPERTY_SOURCE_LOADER)) {
                propertySourceLoaderTypes = new ArrayList(propertySourceLoaderTypes);
                propertySourceLoaderTypes.add(YAML_PROPERTY_SOURCE_LOADER);
            }
        }
        if (propertySourceLoaderTypes.isEmpty()) {
            LOG.info("Option {} has no value. Using default instead: {}", (Object)TYPES_OPTION.key(), (Object)TYPES_OPTION.sampleValue());
            propertySourceLoaderTypes = Arrays.stream(TYPES_OPTION.sampleValue().split(",")).map(String::trim).collect(Collectors.toList());
        }
        this.propertySourceLoaderTypes = propertySourceLoaderTypes;
        this.baseOrder = (Integer)context.getConfiguration().optionalValue(BASE_ORDER_OPTION.key(), v -> v.map(Integer::parseInt).orElse(-1073741824));
        this.environments = environments;
        this.serviceLoaderExclude = (Boolean)context.getConfiguration().optionalValue(SERVICE_LOADER_EXCLUDE_OPTION.key(), v -> v.map(Boolean::parseBoolean).orElse(true));
    }

    public void generate(@NonNull AOTContext context) {
        for (String propertySourceLoaderType : this.propertySourceLoaderTypes) {
            Optional<PropertySourceLoader> loader = this.createLoader(propertySourceLoaderType);
            if (!loader.isPresent()) continue;
            if (this.serviceLoaderExclude) {
                context.registerExcludedServiceImpl(propertySourceLoaderType, "Excluded by %s because property sources are generated based on the loader as specified by %s".formatted(((Object)((Object)this)).getClass().getSimpleName(), TYPES_OPTION.key()));
            }
            for (String resource : this.resources) {
                this.createMapProperty(loader.get(), context, resource, null);
                for (ActiveEnvironment environment : this.environments) {
                    this.createMapProperty(loader.get(), context, resource, environment);
                }
            }
        }
    }

    private Optional<PropertySourceLoader> createLoader(String className) {
        Class<?> loaderClass;
        try {
            Class<?> classValue = Class.forName(className);
            if (!PropertySourceLoader.class.isAssignableFrom(classValue)) {
                LOG.error("The loader class {} does not extend AbstractPropertySourceLoader and cannot be used for loading properties with AOT", (Object)className);
                return Optional.empty();
            }
            loaderClass = classValue;
        }
        catch (ClassNotFoundException e) {
            LOG.error("Could not load the loader class: {} ({})", (Object)className, (Object)e.getMessage());
            return Optional.empty();
        }
        Constructor<?> defaultConstructor = null;
        for (Constructor<?> constructor : loaderClass.getDeclaredConstructors()) {
            if (constructor.getParameters().length != 0) continue;
            defaultConstructor = constructor;
        }
        if (defaultConstructor == null) {
            LOG.error("Did not find a default constructor for the loader class: {}", (Object)className);
            return Optional.empty();
        }
        try {
            return Optional.of((PropertySourceLoader)defaultConstructor.newInstance(new Object[0]));
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            LOG.error("Could not initialize an instance of the class: {} ({})", (Object)className, (Object)e.getMessage());
            return Optional.empty();
        }
    }

    private void createMapProperty(PropertySourceLoader loader, AOTContext context, String resource, @Nullable ActiveEnvironment environment) {
        Optional optionalSource = environment != null ? loader.loadEnv(resource, (ResourceLoader)new DefaultClassPathResourceLoader(((Object)((Object)this)).getClass().getClassLoader()), environment) : loader.load(resource, (ResourceLoader)new DefaultClassPathResourceLoader(((Object)((Object)this)).getClass().getClassLoader()));
        if (optionalSource.isPresent()) {
            LOG.info("Converting {} into Java based configuration with loader {}", (Object)resource, (Object)loader.getClass().getSimpleName());
            for (String extension : loader.getExtensions()) {
                context.registerExcludedResource(resource + (String)(environment == null ? "" : "-" + environment.getName()) + "." + extension);
            }
            PropertySource ps = (PropertySource)optionalSource.get();
            if (ps instanceof MapPropertySource) {
                MapPropertySource mps = (MapPropertySource)ps;
                Map values = mps.asMap();
                MapPropertySourceGenerator generator = new MapPropertySourceGenerator(this.getNamePrefix(loader), resource + (environment == null ? "" : StringUtils.capitalize((String)environment.getName())), values, mps.getOrder() + this.baseOrder);
                generator.generate(context);
            } else if (!(ps instanceof EmptyPropertySource)) {
                throw new UnsupportedOperationException("Unknown property source type:" + ps.getClass());
            }
        }
    }

    private String getNamePrefix(PropertySourceLoader loader) {
        String namePrefix = loader.getClass().getSimpleName();
        if (namePrefix.endsWith(PropertySourceLoader.class.getSimpleName())) {
            namePrefix = namePrefix.substring(0, namePrefix.length() - PropertySourceLoader.class.getSimpleName().length());
        }
        return namePrefix;
    }
}

