/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aws.alexa.builders;

import com.amazon.ask.AlexaSkill;
import com.amazon.ask.builder.SkillBuilder;
import com.amazon.ask.dispatcher.exception.ExceptionHandler;
import com.amazon.ask.dispatcher.request.handler.RequestHandler;
import com.amazon.ask.dispatcher.request.interceptor.RequestInterceptor;
import com.amazon.ask.dispatcher.request.interceptor.ResponseInterceptor;
import com.amazon.ask.model.RequestEnvelope;
import com.amazon.ask.model.ResponseEnvelope;
import io.micronaut.aws.alexa.builders.AlexaSkillBuilder;
import io.micronaut.aws.alexa.conf.AlexaSkillConfiguration;
import io.micronaut.context.ApplicationContext;
import io.micronaut.core.naming.Named;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.inject.qualifiers.Qualifiers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Singleton;
import javax.validation.constraints.NotNull;

@Singleton
public class DefaultAlexaSkillBuilder
implements AlexaSkillBuilder<RequestEnvelope, ResponseEnvelope> {
    private final Map<String, SkillBeans> skillBeans = new HashMap<String, SkillBeans>();
    private final SkillBeans unqualifiedSkillBeans;

    public DefaultAlexaSkillBuilder(Collection<AlexaSkillConfiguration> alexaSkillConfigurations, ApplicationContext applicationContext) {
        HashMap<String, Collection<RequestHandler>> requestHandlersBySkillName = new HashMap<String, Collection<RequestHandler>>();
        HashMap<String, Collection<ExceptionHandler>> exceptionHandlersBySkillName = new HashMap<String, Collection<ExceptionHandler>>();
        HashMap<String, Collection<RequestInterceptor>> requestInterceptorsBySkillName = new HashMap<String, Collection<RequestInterceptor>>();
        HashMap<String, Collection<ResponseInterceptor>> responseInterceptorsBySkillName = new HashMap<String, Collection<ResponseInterceptor>>();
        List names = alexaSkillConfigurations.stream().map(Named::getName).collect(Collectors.toList());
        for (String name : names) {
            requestHandlersBySkillName.put(name, applicationContext.getBeansOfType(RequestHandler.class, Qualifiers.byName((String)name)));
            exceptionHandlersBySkillName.put(name, applicationContext.getBeansOfType(ExceptionHandler.class, Qualifiers.byName((String)name)));
            requestInterceptorsBySkillName.put(name, applicationContext.getBeansOfType(RequestInterceptor.class, Qualifiers.byName((String)name)));
            responseInterceptorsBySkillName.put(name, applicationContext.getBeansOfType(ResponseInterceptor.class, Qualifiers.byName((String)name)));
        }
        Collection requestHandlers = applicationContext.getBeansOfType(RequestHandler.class);
        ArrayList<RequestHandler> unqualifiedRequestHandlers = new ArrayList<RequestHandler>(requestHandlers);
        for (String name : requestHandlersBySkillName.keySet()) {
            unqualifiedRequestHandlers.removeAll((Collection)requestHandlersBySkillName.get(name));
        }
        Collection exceptionHandlers = applicationContext.getBeansOfType(ExceptionHandler.class);
        ArrayList<ExceptionHandler> unqualifiedExceptionHandlers = new ArrayList<ExceptionHandler>(exceptionHandlers);
        for (String name : exceptionHandlersBySkillName.keySet()) {
            unqualifiedExceptionHandlers.removeAll((Collection)exceptionHandlersBySkillName.get(name));
        }
        Collection requestInterceptors = applicationContext.getBeansOfType(RequestInterceptor.class);
        ArrayList<RequestInterceptor> unqualifiedRequestInterceptors = new ArrayList<RequestInterceptor>(requestInterceptors);
        for (String name : requestInterceptorsBySkillName.keySet()) {
            unqualifiedRequestInterceptors.removeAll((Collection)requestInterceptorsBySkillName.get(name));
        }
        Collection responseInterceptors = applicationContext.getBeansOfType(ResponseInterceptor.class);
        ArrayList<ResponseInterceptor> unqualifiedResponseInterceptors = new ArrayList<ResponseInterceptor>(responseInterceptors);
        for (String name : responseInterceptorsBySkillName.keySet()) {
            unqualifiedResponseInterceptors.removeAll((Collection)responseInterceptorsBySkillName.get(name));
        }
        for (String name : names) {
            this.skillBeans.put(name, this.skillBeansByName(name, requestHandlersBySkillName, exceptionHandlersBySkillName, requestInterceptorsBySkillName, responseInterceptorsBySkillName, unqualifiedRequestHandlers, unqualifiedExceptionHandlers, unqualifiedRequestInterceptors, unqualifiedResponseInterceptors));
        }
        this.unqualifiedSkillBeans = new SkillBeans(unqualifiedRequestHandlers, unqualifiedExceptionHandlers, unqualifiedRequestInterceptors, unqualifiedResponseInterceptors);
    }

    @Override
    @Nonnull
    public AlexaSkill<RequestEnvelope, ResponseEnvelope> buildSkill(@Nonnull @NotNull SkillBuilder<?> skillBuilder, @Nullable AlexaSkillConfiguration alexaSkillConfiguration) {
        SkillBeans skillBeans = alexaSkillConfiguration == null ? this.unqualifiedSkillBeans : this.skillBeans.get(alexaSkillConfiguration.getName());
        skillBeans.getRequestHandlers().stream().sorted(OrderUtil.COMPARATOR).forEach(arg_0 -> skillBuilder.addRequestHandler(arg_0));
        skillBeans.getExceptionHandlers().stream().sorted(OrderUtil.COMPARATOR).forEach(arg_0 -> skillBuilder.addExceptionHandler(arg_0));
        skillBeans.getRequestInterceptors().stream().sorted(OrderUtil.COMPARATOR).forEach(arg_0 -> skillBuilder.addRequestInterceptor(arg_0));
        skillBeans.getResponseInterceptors().stream().sorted(OrderUtil.COMPARATOR).forEach(arg_0 -> skillBuilder.addResponseInterceptor(arg_0));
        if (alexaSkillConfiguration != null) {
            skillBuilder = skillBuilder.withSkillId(alexaSkillConfiguration.getSkillId());
        }
        return skillBuilder.build();
    }

    private SkillBeans skillBeansByName(String name, Map<String, Collection<RequestHandler>> requestHandlersBySkillName, Map<String, Collection<ExceptionHandler>> exceptionHandlersBySkillName, Map<String, Collection<RequestInterceptor>> requestInterceptorsBySkillName, Map<String, Collection<ResponseInterceptor>> responseInterceptorsBySkillName, List<RequestHandler> unqualifiedRequestHandlers, List<ExceptionHandler> unqualifiedExceptionHandlers, List<RequestInterceptor> unqualifiedRequestInterceptors, List<ResponseInterceptor> unqualifiedResponseInterceptors) {
        ArrayList<RequestHandler> requestHandlers = new ArrayList<RequestHandler>();
        requestHandlers.addAll(unqualifiedRequestHandlers);
        if (name != null && requestHandlersBySkillName.containsKey(name)) {
            requestHandlers.addAll(requestHandlersBySkillName.get(name));
        }
        ArrayList<ExceptionHandler> exceptionHandlers = new ArrayList<ExceptionHandler>();
        exceptionHandlers.addAll(unqualifiedExceptionHandlers);
        if (name != null && exceptionHandlersBySkillName.containsKey(name)) {
            exceptionHandlers.addAll(exceptionHandlersBySkillName.get(name));
        }
        ArrayList<RequestInterceptor> requestInterceptors = new ArrayList<RequestInterceptor>();
        requestInterceptors.addAll(unqualifiedRequestInterceptors);
        if (name != null && requestInterceptorsBySkillName.containsKey(name)) {
            requestInterceptors.addAll(requestInterceptorsBySkillName.get(name));
        }
        ArrayList<ResponseInterceptor> responseInterceptors = new ArrayList<ResponseInterceptor>();
        responseInterceptors.addAll(unqualifiedResponseInterceptors);
        if (name != null && responseInterceptorsBySkillName.containsKey(name)) {
            responseInterceptors.addAll(responseInterceptorsBySkillName.get(name));
        }
        return new SkillBeans(requestHandlers, exceptionHandlers, requestInterceptors, responseInterceptors);
    }

    private static class SkillBeans {
        private List<RequestHandler> requestHandlers;
        private List<ExceptionHandler> exceptionHandlers;
        private List<RequestInterceptor> requestInterceptors;
        private List<ResponseInterceptor> responseInterceptors;

        public SkillBeans(List<RequestHandler> requestHandlers, List<ExceptionHandler> exceptionHandlers, List<RequestInterceptor> requestInterceptors, List<ResponseInterceptor> responseInterceptors) {
            this.requestHandlers = requestHandlers;
            this.exceptionHandlers = exceptionHandlers;
            this.requestInterceptors = requestInterceptors;
            this.responseInterceptors = responseInterceptors;
        }

        public List<RequestHandler> getRequestHandlers() {
            return this.requestHandlers;
        }

        public void setRequestHandlers(List<RequestHandler> requestHandlers) {
            this.requestHandlers = requestHandlers;
        }

        public List<ExceptionHandler> getExceptionHandlers() {
            return this.exceptionHandlers;
        }

        public void setExceptionHandlers(List<ExceptionHandler> exceptionHandlers) {
            this.exceptionHandlers = exceptionHandlers;
        }

        public List<RequestInterceptor> getRequestInterceptors() {
            return this.requestInterceptors;
        }

        public void setRequestInterceptors(List<RequestInterceptor> requestInterceptors) {
            this.requestInterceptors = requestInterceptors;
        }

        public List<ResponseInterceptor> getResponseInterceptors() {
            return this.responseInterceptors;
        }

        public void setResponseInterceptors(List<ResponseInterceptor> responseInterceptors) {
            this.responseInterceptors = responseInterceptors;
        }
    }
}

