/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aws.alexa.builders;

import com.amazon.ask.AlexaSkill;
import com.amazon.ask.Skill;
import io.micronaut.aws.alexa.builders.AlexaSkillBuilder;
import io.micronaut.aws.alexa.builders.SkillBuilderProvider;
import io.micronaut.aws.alexa.conf.AlexaSkillConfiguration;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;

@Requirements(value={@Requires(beans={SkillBuilderProvider.class}), @Requires(beans={AlexaSkillBuilder.class})})
@Factory
public class StandardSkillFactory {
    private final AlexaSkillBuilder alexaSkillBuilder;
    private final SkillBuilderProvider skillBuilderProvider;

    public StandardSkillFactory(AlexaSkillBuilder alexaSkillBuilder, SkillBuilderProvider skillBuilderProvider) {
        this.alexaSkillBuilder = alexaSkillBuilder;
        this.skillBuilderProvider = skillBuilderProvider;
    }

    @EachBean(value=AlexaSkillConfiguration.class)
    public AlexaSkill createStandardAlexaSkill(@Parameter AlexaSkillConfiguration alexaSkillConfiguration) {
        return this.alexaSkillBuilder.buildSkill(this.skillBuilderProvider.getSkillBuilder(), alexaSkillConfiguration);
    }

    @EachBean(value=AlexaSkillConfiguration.class)
    public Skill createSkill(@Parameter AlexaSkillConfiguration alexaSkillConfiguration) {
        AlexaSkill alexaSkill = this.alexaSkillBuilder.buildSkill(this.skillBuilderProvider.getSkillBuilder(), alexaSkillConfiguration);
        if (alexaSkill instanceof Skill) {
            return (Skill)alexaSkill;
        }
        return null;
    }
}

