/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aws.alexa.handlers;

import com.amazon.ask.dispatcher.request.handler.HandlerInput;
import com.amazon.ask.dispatcher.request.handler.RequestHandler;
import com.amazon.ask.request.Predicates;
import io.micronaut.aws.alexa.annotation.IntentHandler;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.reflect.InstantiationUtils;
import io.micronaut.core.util.StringUtils;
import java.util.Arrays;
import java.util.Optional;

@FunctionalInterface
public interface AnnotatedRequestHandler
extends RequestHandler {
    default public boolean canHandle(HandlerInput handlerInput) {
        Class<?> type = this.getClass();
        String annotationMetadata = type.getPackage().getName() + ".$" + type.getSimpleName() + "DefinitionClass";
        AnnotationMetadata metadata = ClassUtils.forName((String)annotationMetadata, (ClassLoader)type.getClassLoader()).flatMap(aClass -> {
            Object o = InstantiationUtils.tryInstantiate((Class)aClass).orElse(null);
            if (o instanceof AnnotationMetadataProvider) {
                return Optional.of(((AnnotationMetadataProvider)o).getAnnotationMetadata());
            }
            return Optional.empty();
        }).orElse(AnnotationMetadata.EMPTY_METADATA);
        String[] names = metadata.getValue(IntentHandler.class, String[].class).orElse(StringUtils.EMPTY_STRING_ARRAY);
        return Arrays.stream(names).anyMatch(n -> handlerInput.matches(Predicates.intentName((String)n)));
    }
}

