/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aws.alexa.ssml;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.aws.alexa.ssml.AmazonDomain;
import io.micronaut.aws.alexa.ssml.AmazonEffect;
import io.micronaut.aws.alexa.ssml.AmazonEmotion;
import io.micronaut.aws.alexa.ssml.AmazonEmotionIntensity;
import io.micronaut.aws.alexa.ssml.BreakStrength;
import io.micronaut.aws.alexa.ssml.EmphasisLevel;
import io.micronaut.aws.alexa.ssml.InterpretAs;
import io.micronaut.aws.alexa.ssml.InterpretAsDateFormat;
import io.micronaut.aws.alexa.ssml.ProsodyPitch;
import io.micronaut.aws.alexa.ssml.ProsodyRate;
import io.micronaut.aws.alexa.ssml.ProsodyVolume;
import io.micronaut.aws.alexa.ssml.SupportedLang;
import io.micronaut.aws.alexa.ssml.Voice;
import io.micronaut.aws.alexa.ssml.WordRole;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nonnull;

public class Ssml {
    public static final String ATTRIBUTE_NAME = "name";
    public static final String OPEN_TAG = "<";
    public static final String CLOSE_TAG = ">";
    public static final String OPEN_CLOSE_TAG = "</";
    public static final String CLOSE_OPENING_TAG = "/>";
    public static final String INTERPRET_AS = "interpret-as";
    public static final String FORMAT = "format";
    public static final String TAG_AMAZON_DOMAIN = "amazon:domain";
    public static final String TAG_AMAZON_EFFECT = "amazon:effect";
    public static final String TAG_AMAZON_EMOTION = "amazon:emotion";
    public static final String TAG_AUDIO = "audio";
    public static final String TAG_BREAK = "break";
    public static final String TAG_EMPHASIS = "emphasis";
    public static final String TAG_LANG = "lang";
    public static final String TAG_P = "p";
    public static final String TAG_PHONEME = "phoneme";
    public static final String TAG_PROSODY = "prosody";
    public static final String TAG_S = "s";
    public static final String TAG_SAY_AS = "say-as";
    public static final String TAG_SPEAK = "speak";
    public static final String TAG_SUB = "sub";
    public static final String TAG_VOICE = "voice";
    public static final String TAG_W = "w";
    public static final String XML_LANG = "xml:lang";
    public static final String RATE = "rate";
    public static final String PITCH = "pitch";
    public static final String VOLUME = "volume";
    public static final String SRC = "src";
    private StringBuffer result = new StringBuffer();

    public Ssml() {
    }

    public Ssml(String text) {
        this.result.append(text);
    }

    public Ssml domain(@NonNull AmazonDomain domain, @NonNull String text) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.openTag(TAG_AMAZON_DOMAIN, Collections.singletonMap(ATTRIBUTE_NAME, domain.toString())));
        sb.append(text);
        sb.append(this.closeTag(TAG_AMAZON_DOMAIN));
        this.result.append(sb);
        return this;
    }

    public Ssml audio(@NonNull String src) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.openTag(TAG_AUDIO, Collections.singletonMap(SRC, src), true));
        this.result.append(sb);
        return this;
    }

    public Ssml effect(@NonNull AmazonEffect effect, @NonNull String text) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.openTag(TAG_AMAZON_EFFECT, Collections.singletonMap(ATTRIBUTE_NAME, effect.toString())));
        sb.append(text);
        sb.append(this.closeTag(TAG_AMAZON_EFFECT));
        this.result.append(sb);
        return this;
    }

    public Ssml text(@NonNull String text) {
        this.result.append(text);
        return this;
    }

    public Ssml emotion(@NonNull AmazonEmotion emotion, @NonNull AmazonEmotionIntensity intensity, @NonNull String text) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put(ATTRIBUTE_NAME, emotion.toString());
        attributes.put("intensity", intensity.toString());
        StringBuffer sb = new StringBuffer();
        sb.append(this.openTag(TAG_AMAZON_EMOTION, attributes));
        sb.append(text);
        sb.append(this.closeTag(TAG_AMAZON_EMOTION));
        this.result.append(sb);
        return this;
    }

    public Ssml lang(@Nonnull String text, @NonNull SupportedLang lang) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.openTag(TAG_LANG, Collections.singletonMap(XML_LANG, lang.toString())));
        sb.append(text);
        sb.append(this.closeTag(TAG_LANG));
        this.result.append(sb);
        return this;
    }

    public Ssml paragraph(@Nonnull String text) {
        return this.p(text);
    }

    public Ssml prosody(@Nonnull String text, @Nullable ProsodyRate rate, @Nullable ProsodyPitch pitch, @Nullable ProsodyVolume volume) {
        StringBuffer sb = new StringBuffer();
        HashMap<String, String> attributes = new HashMap<String, String>();
        if (rate != null) {
            attributes.put(RATE, rate.toString());
        }
        if (pitch != null) {
            attributes.put(PITCH, pitch.toString());
        }
        if (volume != null) {
            attributes.put(VOLUME, volume.toString());
        }
        sb.append(this.openTag(TAG_PROSODY, attributes));
        sb.append(text);
        sb.append(this.closeTag(TAG_PROSODY));
        this.result.append(sb);
        return this;
    }

    public Ssml sentence(@Nonnull String text) {
        return this.s(text);
    }

    public Ssml speak(@Nonnull String text) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.openTag(TAG_SPEAK, null));
        sb.append(text);
        sb.append(this.closeTag(TAG_SPEAK));
        this.result.append(sb);
        return this;
    }

    public Ssml s(@Nonnull String text) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.openTag(TAG_S, null));
        sb.append(text);
        sb.append(this.closeTag(TAG_S));
        this.result.append(sb);
        return this;
    }

    public Ssml p(@Nonnull String text) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.openTag(TAG_P, null));
        sb.append(text);
        sb.append(this.closeTag(TAG_P));
        this.result.append(sb);
        return this;
    }

    public Ssml sayAs(@Nonnull String text, @NonNull InterpretAs interpretAs, @Nullable InterpretAsDateFormat interpretAsDateFormat) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put(INTERPRET_AS, interpretAs.toString());
        if (interpretAsDateFormat != null) {
            attributes.put(FORMAT, interpretAsDateFormat.toString());
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this.openTag(TAG_SAY_AS, attributes));
        sb.append(text);
        sb.append(this.closeTag(TAG_SAY_AS));
        this.result.append(sb);
        return this;
    }

    public Ssml w(@Nonnull String text, @NonNull WordRole role) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.openTag(TAG_W, Collections.singletonMap("role", role.toString())));
        sb.append(text);
        sb.append(this.closeTag(TAG_W));
        this.result.append(sb);
        return this;
    }

    public Ssml emphasis(@Nonnull String text, @Nullable EmphasisLevel emphasisLevel) {
        StringBuffer sb = new StringBuffer();
        if (emphasisLevel == null) {
            sb.append(this.openTag(TAG_EMPHASIS, null));
        } else {
            sb.append(this.openTag(TAG_EMPHASIS, Collections.singletonMap("level", emphasisLevel.toString())));
        }
        sb.append(text);
        sb.append(this.closeTag(TAG_EMPHASIS));
        this.result.append(sb);
        return this;
    }

    public Ssml breakWithSeconds(@NonNull Integer seconds) {
        return this.breakWithAttributes(Collections.singletonMap("time", seconds + TAG_S));
    }

    public Ssml voice(@NonNull String text, @NonNull Voice voice) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.openTag(TAG_VOICE, Collections.singletonMap(ATTRIBUTE_NAME, voice.toString())));
        sb.append(text);
        sb.append(this.closeTag(TAG_VOICE));
        this.result.append(sb);
        return this;
    }

    public Ssml sub(@NonNull String text, @NonNull String alias) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.openTag(TAG_SUB, Collections.singletonMap("alias", alias)));
        sb.append(text);
        sb.append(this.closeTag(TAG_SUB));
        this.result.append(sb);
        return this;
    }

    public Ssml breakWithMilliseconds(@NonNull Integer milliseconds) {
        return this.breakWithAttributes(Collections.singletonMap("time", milliseconds + "ms"));
    }

    public Ssml breakWithStrength(@NonNull BreakStrength strength) {
        return this.breakWithAttributes(Collections.singletonMap("strength", strength.toString()));
    }

    public String build() {
        return this.result.toString();
    }

    private Ssml breakWithAttributes(@NonNull Map<String, String> attributes) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.openTag(TAG_BREAK, attributes, true));
        this.result.append(sb);
        return this;
    }

    private String closeTag(@NonNull String tagName) {
        StringBuffer sb = new StringBuffer();
        sb.append(OPEN_CLOSE_TAG);
        sb.append(tagName);
        sb.append(CLOSE_TAG);
        return sb.toString();
    }

    private String openTag(@NonNull String tagName, @Nullable Map<String, String> attributes) {
        return this.openTag(tagName, attributes, null);
    }

    private String openTag(@NonNull String tagName, @Nullable Map<String, String> attributes, @Nullable Boolean close) {
        StringBuffer sb = new StringBuffer();
        sb.append(OPEN_TAG);
        sb.append(tagName);
        if (attributes != null) {
            Collection<String> attributeNames = null;
            if (attributes.containsKey(ATTRIBUTE_NAME)) {
                HashSet<String> attributesSet = new HashSet<String>(attributes.keySet());
                attributeNames = new ArrayList();
                if (attributesSet.contains(ATTRIBUTE_NAME)) {
                    attributeNames.add(ATTRIBUTE_NAME);
                    attributesSet.remove(ATTRIBUTE_NAME);
                }
                attributeNames.addAll(attributesSet);
            }
            for (String attributeName : attributeNames != null ? attributeNames : attributes.keySet()) {
                sb.append(" ");
                sb.append(attributeName);
                sb.append("=\"");
                sb.append(attributes.get(attributeName));
                sb.append("\"");
            }
        }
        if (close != null && close.booleanValue()) {
            sb.append(CLOSE_OPENING_TAG);
        } else {
            sb.append(CLOSE_TAG);
        }
        return sb.toString();
    }
}

