/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aws.apigateway;

import com.amazonaws.services.lambda.runtime.events.APIGatewayProxyRequestEvent;
import com.amazonaws.services.lambda.runtime.events.APIGatewayV2HTTPEvent;
import io.micronaut.aws.apigateway.StageResolver;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.http.HttpRequest;
import io.micronaut.servlet.http.ServletHttpRequest;
import jakarta.inject.Singleton;
import java.util.Optional;

@Requires(classes={ServletHttpRequest.class, HttpRequest.class})
@Singleton
public class HttpRequestStageResolver
implements StageResolver<HttpRequest<?>> {
    @Override
    @NonNull
    public Optional<String> resolve(@NonNull HttpRequest<?> request) {
        if (request instanceof ServletHttpRequest) {
            APIGatewayProxyRequestEvent apiGatewayProxyRequestEvent;
            APIGatewayV2HTTPEvent aPIGatewayV2HTTPEvent;
            ServletHttpRequest servletHttpRequest = (ServletHttpRequest)request;
            Object nativeRequest = servletHttpRequest.getNativeRequest();
            if (nativeRequest instanceof APIGatewayV2HTTPEvent && (aPIGatewayV2HTTPEvent = (APIGatewayV2HTTPEvent)nativeRequest).getRequestContext() != null) {
                return Optional.of(aPIGatewayV2HTTPEvent.getRequestContext().getStage());
            }
            if (nativeRequest instanceof APIGatewayProxyRequestEvent && (apiGatewayProxyRequestEvent = (APIGatewayProxyRequestEvent)nativeRequest).getRequestContext() != null) {
                return Optional.of(apiGatewayProxyRequestEvent.getRequestContext().getStage());
            }
        }
        return Optional.empty();
    }
}

