/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aws.cdk.function;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.starter.options.BuildTool;

public final class MicronautFunctionFile {
    private static final String OPTIMIZED = "optimized";
    private static final String JAR = "jar";
    private static final String ALL = "all";
    private static final String DASH = "-";
    private static final String LAMBDA = "lambda";
    private static final String ZIP = "zip";
    private static final String DOT = ".";
    private static final String FUNCTION = "function";

    private MicronautFunctionFile() {
    }

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private BuildTool buildTool = BuildTool.GRADLE;
        private String version;
        private boolean optimized;
        private boolean graalVMNative;
        private String archiveBaseName;

        @NonNull
        public Builder buildTool(@NonNull BuildTool buildTool) {
            this.buildTool = buildTool;
            return this;
        }

        @NonNull
        public Builder version(@NonNull String version) {
            this.version = version;
            return this;
        }

        @NonNull
        public Builder archiveBaseName(@NonNull String archiveBaseName) {
            this.archiveBaseName = archiveBaseName;
            return this;
        }

        @NonNull
        public Builder optimized(boolean optimized) {
            this.optimized = optimized;
            return this;
        }

        @NonNull
        public Builder optimized() {
            return this.optimized(true);
        }

        @NonNull
        public Builder graalVMNative(boolean graalVMNative) {
            this.graalVMNative = graalVMNative;
            return this;
        }

        @NonNull
        public Builder graalVMNative() {
            return this.graalVMNative(true);
        }

        @NonNull
        public String build() {
            switch (this.buildTool) {
                case MAVEN: {
                    CharSequence[] charSequenceArray;
                    if (this.graalVMNative) {
                        return String.join((CharSequence)MicronautFunctionFile.DOT, MicronautFunctionFile.FUNCTION, MicronautFunctionFile.ZIP);
                    }
                    if (this.version != null) {
                        String[] stringArray = new String[2];
                        stringArray[0] = String.join((CharSequence)MicronautFunctionFile.DASH, this.archiveBaseName, this.version);
                        charSequenceArray = stringArray;
                        stringArray[1] = MicronautFunctionFile.JAR;
                    } else {
                        CharSequence[] charSequenceArray2 = new String[2];
                        charSequenceArray2[0] = this.archiveBaseName;
                        charSequenceArray = charSequenceArray2;
                        charSequenceArray2[1] = MicronautFunctionFile.JAR;
                    }
                    return String.join((CharSequence)MicronautFunctionFile.DOT, charSequenceArray);
                }
            }
            return String.join((CharSequence)MicronautFunctionFile.DOT, String.join((CharSequence)MicronautFunctionFile.DASH, this.graalVMNative ? Builder.gradleZipFilenameComponents(this.optimized, this.archiveBaseName, this.version) : Builder.gradleJarFilenameComponents(this.optimized, this.archiveBaseName, this.version)), this.graalVMNative ? MicronautFunctionFile.ZIP : MicronautFunctionFile.JAR);
        }

        private static String[] gradleJarFilenameComponents(boolean optimized, String archiveBaseName, String version) {
            String[] stringArray;
            if (version != null) {
                String[] stringArray2;
                if (optimized) {
                    String[] stringArray3 = new String[4];
                    stringArray3[0] = archiveBaseName;
                    stringArray3[1] = version;
                    stringArray3[2] = MicronautFunctionFile.ALL;
                    stringArray2 = stringArray3;
                    stringArray3[3] = MicronautFunctionFile.OPTIMIZED;
                } else {
                    String[] stringArray4 = new String[3];
                    stringArray4[0] = archiveBaseName;
                    stringArray4[1] = version;
                    stringArray2 = stringArray4;
                    stringArray4[2] = MicronautFunctionFile.ALL;
                }
                return stringArray2;
            }
            if (optimized) {
                String[] stringArray5 = new String[3];
                stringArray5[0] = archiveBaseName;
                stringArray5[1] = MicronautFunctionFile.ALL;
                stringArray = stringArray5;
                stringArray5[2] = MicronautFunctionFile.OPTIMIZED;
            } else {
                String[] stringArray6 = new String[2];
                stringArray6[0] = archiveBaseName;
                stringArray = stringArray6;
                stringArray6[1] = MicronautFunctionFile.ALL;
            }
            return stringArray;
        }

        private static String[] gradleZipFilenameComponents(boolean optimized, @NonNull String archiveBaseName, @Nullable String version) {
            String[] stringArray;
            if (version != null) {
                String[] stringArray2;
                if (optimized) {
                    String[] stringArray3 = new String[4];
                    stringArray3[0] = archiveBaseName;
                    stringArray3[1] = version;
                    stringArray3[2] = MicronautFunctionFile.OPTIMIZED;
                    stringArray2 = stringArray3;
                    stringArray3[3] = MicronautFunctionFile.LAMBDA;
                } else {
                    String[] stringArray4 = new String[3];
                    stringArray4[0] = archiveBaseName;
                    stringArray4[1] = version;
                    stringArray2 = stringArray4;
                    stringArray4[2] = MicronautFunctionFile.LAMBDA;
                }
                return stringArray2;
            }
            if (optimized) {
                String[] stringArray5 = new String[3];
                stringArray5[0] = archiveBaseName;
                stringArray5[1] = MicronautFunctionFile.OPTIMIZED;
                stringArray = stringArray5;
                stringArray5[2] = MicronautFunctionFile.LAMBDA;
            } else {
                String[] stringArray6 = new String[2];
                stringArray6[0] = archiveBaseName;
                stringArray = stringArray6;
                stringArray6[1] = MicronautFunctionFile.LAMBDA;
            }
            return stringArray;
        }
    }
}

