/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aws.cloudwatch.logging;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.net.QueueFactory;
import ch.qos.logback.core.spi.AppenderAttachable;
import ch.qos.logback.core.util.Duration;
import io.micronaut.aws.cloudwatch.logging.CloudWatchLoggingClient;
import io.micronaut.core.annotation.Internal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.services.cloudwatchlogs.model.CreateLogGroupRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.CreateLogStreamRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.InputLogEvent;
import software.amazon.awssdk.services.cloudwatchlogs.model.InvalidSequenceTokenException;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutLogEventsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutLogEventsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.ResourceAlreadyExistsException;

@Internal
public final class CloudWatchLoggingAppender
extends AppenderBase<ILoggingEvent>
implements AppenderAttachable<ILoggingEvent> {
    private static final int DEFAULT_QUEUE_SIZE = 128;
    private static final int DEFAULT_MAX_BATCH_SIZE = 128;
    private static final int PUT_REQUEST_RETRY_COUNT = 2;
    private static final long DEFAULT_PUBLISH_PERIOD = 100L;
    private final QueueFactory queueFactory = new QueueFactory();
    private Duration eventDelayLimit;
    private final List<String> blackListLoggerName = new ArrayList<String>();
    private Encoder<ILoggingEvent> encoder;
    private Future<?> task;
    private BlockingDeque<ILoggingEvent> deque;
    private int queueSize = 128;
    private long publishPeriod = 100L;
    private Appender<ILoggingEvent> emergencyAppender;
    private String sequenceToken = null;
    private boolean configuredSuccessfully = false;
    private boolean createGroupAndStream = true;
    private int maxBatchSize = 128;
    private String groupName;
    private String streamName;
    private boolean dispatchOnStart = false;
    private volatile boolean dispatchThreadStarted = false;

    public int getQueueSize() {
        return this.queueSize;
    }

    public void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
    }

    public void addBlackListLoggerName(String test) {
        this.blackListLoggerName.add(test);
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public void setStreamName(String streamName) {
        this.streamName = streamName;
    }

    public long getPublishPeriod() {
        return this.publishPeriod;
    }

    public void setPublishPeriod(long publishPeriod) {
        this.publishPeriod = publishPeriod;
    }

    public int getMaxBatchSize() {
        return this.maxBatchSize;
    }

    public void setMaxBatchSize(int maxBatchSize) {
        this.maxBatchSize = maxBatchSize;
    }

    public boolean isCreateGroupAndStream() {
        return this.createGroupAndStream;
    }

    public void setCreateGroupAndStream(boolean createGroupAndStream) {
        this.createGroupAndStream = createGroupAndStream;
    }

    public boolean isDispatchOnStart() {
        return this.dispatchOnStart;
    }

    public void setDispatchOnStart(boolean dispatchOnStart) {
        this.dispatchOnStart = dispatchOnStart;
    }

    public void start() {
        if (this.isStarted()) {
            return;
        }
        if (this.queueSize == 0) {
            this.addWarn("Queue size of zero is deprecated, use a size of one to indicate synchronous processing");
        }
        if (this.queueSize < 0) {
            this.addError("Queue size must be greater than zero");
            return;
        }
        if (this.publishPeriod <= 0L) {
            this.addError("Publish period must be greater than zero");
            return;
        }
        if (this.maxBatchSize <= 0) {
            this.addError("Max Batch size must be greater than zero");
            return;
        }
        if (this.encoder == null) {
            this.addError("No encoder set for the appender named [" + this.name + "].");
            return;
        }
        if (this.emergencyAppender != null && !this.emergencyAppender.isStarted()) {
            this.emergencyAppender.start();
        }
        this.eventDelayLimit = new Duration(this.publishPeriod);
        this.deque = this.queueFactory.newLinkedBlockingDeque(this.queueSize);
        if (this.dispatchOnStart) {
            this.startDispatch();
        }
        super.start();
    }

    private void startDispatch() {
        this.task = this.getContext().getScheduledExecutorService().scheduleAtFixedRate(() -> {
            try {
                this.dispatchEvents();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }, 0L, 100L, TimeUnit.MILLISECONDS);
        this.dispatchThreadStarted = true;
    }

    public void stop() {
        if (!this.isStarted()) {
            return;
        }
        this.task.cancel(true);
        super.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void append(ILoggingEvent eventObject) {
        if (eventObject == null || !this.isStarted() || this.blackListLoggerName.contains(eventObject.getLoggerName())) {
            return;
        }
        if (!this.dispatchThreadStarted && !this.dispatchOnStart) {
            CloudWatchLoggingAppender cloudWatchLoggingAppender = this;
            synchronized (cloudWatchLoggingAppender) {
                if (!this.dispatchThreadStarted) {
                    this.startDispatch();
                }
            }
        }
        try {
            boolean inserted = this.deque.offer(eventObject, this.eventDelayLimit.getMilliseconds(), TimeUnit.MILLISECONDS);
            if (!inserted) {
                this.addInfo("Dropping event due to timeout limit of [" + this.eventDelayLimit + "] being exceeded");
            }
        }
        catch (InterruptedException e) {
            this.addError("Interrupted while appending event to SocketAppender", e);
            Thread.currentThread().interrupt();
        }
    }

    public Encoder<ILoggingEvent> getEncoder() {
        return this.encoder;
    }

    public void setEncoder(Encoder<ILoggingEvent> encoder) {
        this.encoder = encoder;
    }

    private boolean tryToConfigure() {
        if (!CloudWatchLoggingClient.isReady()) {
            return false;
        }
        if (this.groupName == null) {
            this.groupName = CloudWatchLoggingClient.getAppName();
        }
        if (this.streamName == null) {
            this.streamName = CloudWatchLoggingClient.getHost();
        }
        if (this.createGroupAndStream) {
            CreateLogGroupRequest createLogGroupRequest = (CreateLogGroupRequest)CreateLogGroupRequest.builder().logGroupName(this.groupName).build();
            try {
                CloudWatchLoggingClient.createLogGroup(createLogGroupRequest);
            }
            catch (ResourceAlreadyExistsException e) {
                this.addInfo(String.format("Log group %s already exists", this.groupName));
            }
            catch (SdkException e) {
                this.addError(String.format("Error creating log group %s", this.groupName), e);
            }
            CreateLogStreamRequest createLogStreamRequest = (CreateLogStreamRequest)CreateLogStreamRequest.builder().logStreamName(this.streamName).logGroupName(this.groupName).build();
            try {
                CloudWatchLoggingClient.createLogStream(createLogStreamRequest);
            }
            catch (ResourceAlreadyExistsException e) {
                this.addInfo(String.format("Log stream %s already exists", this.streamName));
            }
            catch (SdkException e) {
                this.addError(String.format("Error stream log %s", this.streamName), e);
            }
        }
        this.configuredSuccessfully = true;
        return true;
    }

    private void dispatchEvents() throws InterruptedException {
        if (!this.configuredSuccessfully && !this.tryToConfigure()) {
            return;
        }
        ArrayList<InputLogEvent> logEvents = new ArrayList<InputLogEvent>(this.maxBatchSize);
        ArrayList<ILoggingEvent> iLoggingEvents = new ArrayList<ILoggingEvent>(this.maxBatchSize);
        while (!this.deque.isEmpty() && logEvents.size() < this.maxBatchSize) {
            ILoggingEvent event = this.deque.takeFirst();
            InputLogEvent inputLogEvent = (InputLogEvent)InputLogEvent.builder().message(new String(this.encoder.encode((Object)event))).timestamp(Long.valueOf(event.getTimeStamp())).build();
            iLoggingEvents.add(event);
            logEvents.add(inputLogEvent);
        }
        if (!logEvents.isEmpty() && !this.sendLogsToCloudWatch(logEvents) && this.emergencyAppender != null) {
            iLoggingEvents.forEach(arg_0 -> this.emergencyAppender.doAppend(arg_0));
        }
    }

    private boolean sendLogsToCloudWatch(List<InputLogEvent> logEvents) {
        if (this.sequenceToken == null) {
            try {
                this.sequenceToken = CloudWatchLoggingClient.getToken(this.groupName, this.streamName);
            }
            catch (SdkException e) {
                this.addError("Getting token got error", e);
            }
        }
        for (int i = 0; i < 2; ++i) {
            try {
                PutLogEventsResponse putLogEventsResponse = this.putLogs(logEvents, this.groupName, this.streamName, this.sequenceToken);
                if (putLogEventsResponse != null && putLogEventsResponse.nextSequenceToken() != null) {
                    this.sequenceToken = putLogEventsResponse.nextSequenceToken();
                    return true;
                }
                this.addError("Sending log request failed");
                continue;
            }
            catch (InvalidSequenceTokenException e) {
                this.sequenceToken = e.expectedSequenceToken();
                continue;
            }
            catch (Exception e) {
                this.addError("Sending log request failed", e);
                return false;
            }
        }
        return false;
    }

    public void addAppender(Appender<ILoggingEvent> newAppender) {
        if (this.emergencyAppender == null) {
            this.emergencyAppender = newAppender;
        } else {
            this.addWarn("One and only one appender may be attached to " + ((Object)((Object)this)).getClass().getSimpleName());
            this.addWarn("Ignoring additional appender named [" + newAppender.getName() + "]");
        }
    }

    public Iterator<Appender<ILoggingEvent>> iteratorForAppenders() {
        throw new UnsupportedOperationException("Don't know how to create iterator");
    }

    public Appender<ILoggingEvent> getAppender(String name) {
        if (this.emergencyAppender != null && name != null && name.equals(this.emergencyAppender.getName())) {
            return this.emergencyAppender;
        }
        return null;
    }

    public boolean isAttached(Appender<ILoggingEvent> appender) {
        return this.emergencyAppender == appender;
    }

    public void detachAndStopAllAppenders() {
        if (this.emergencyAppender != null) {
            this.emergencyAppender.stop();
            this.emergencyAppender = null;
        }
    }

    public boolean detachAppender(Appender<ILoggingEvent> appender) {
        if (this.emergencyAppender == appender) {
            this.emergencyAppender = null;
            return true;
        }
        return false;
    }

    public boolean detachAppender(String name) {
        if (this.emergencyAppender != null && this.emergencyAppender.getName().equals(name)) {
            this.emergencyAppender = null;
            return true;
        }
        return false;
    }

    private PutLogEventsResponse putLogs(List<InputLogEvent> logEvents, String groupName, String streamName, String sequenceToken) {
        return CloudWatchLoggingClient.putLogs((PutLogEventsRequest)PutLogEventsRequest.builder().logEvents(logEvents).logGroupName(groupName).logStreamName(streamName).sequenceToken(sequenceToken).build());
    }
}

