/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aws.cloudwatch.logging;

import io.micronaut.context.annotation.Context;
import io.micronaut.context.event.ApplicationEventListener;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.runtime.ApplicationConfiguration;
import io.micronaut.runtime.server.event.ServerStartupEvent;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsClient;
import software.amazon.awssdk.services.cloudwatchlogs.model.CreateLogGroupRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.CreateLogStreamRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeLogStreamsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.LogStream;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutLogEventsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutLogEventsResponse;

@Context
@Internal
@Singleton
final class CloudWatchLoggingClient
implements ApplicationEventListener<ServerStartupEvent> {
    private static CloudWatchLogsClient logging;
    private static String host;
    private static String appName;
    private final CloudWatchLogsClient internalLogging;
    private final String internalAppName;

    public CloudWatchLoggingClient(CloudWatchLogsClient logging, ApplicationConfiguration applicationConfiguration) {
        this.internalLogging = logging;
        this.internalAppName = applicationConfiguration.getName().orElse("");
    }

    static synchronized boolean isReady() {
        return logging != null;
    }

    static synchronized String getHost() {
        return host;
    }

    static synchronized String getAppName() {
        return appName;
    }

    private static synchronized void setLogging(CloudWatchLogsClient logging, String host, String appName) {
        CloudWatchLoggingClient.logging = logging;
        CloudWatchLoggingClient.host = host;
        CloudWatchLoggingClient.appName = appName;
    }

    static synchronized void destroy() {
        if (logging != null) {
            logging.close();
        }
        logging = null;
        host = null;
        appName = null;
    }

    static synchronized PutLogEventsResponse putLogs(PutLogEventsRequest putLogsRequest) {
        if (logging != null) {
            return logging.putLogEvents(putLogsRequest);
        }
        return null;
    }

    static synchronized void createLogGroup(CreateLogGroupRequest createLogGroupRequest) {
        if (logging != null) {
            logging.createLogGroup(createLogGroupRequest);
        }
    }

    static synchronized void createLogStream(CreateLogStreamRequest createLogStreamRequest) {
        if (logging != null) {
            logging.createLogStream(createLogStreamRequest);
        }
    }

    @Nullable
    static synchronized String getToken(String groupName, String streamName) {
        Optional<LogStream> first;
        List logStreams = logging.describeLogStreams((DescribeLogStreamsRequest)DescribeLogStreamsRequest.builder().logGroupName(groupName).logStreamNamePrefix(streamName).build()).logStreams();
        if (!logStreams.isEmpty() && (first = logStreams.stream().filter(x -> x.logStreamName().equals(streamName)).findFirst()).isPresent()) {
            return first.get().uploadSequenceToken();
        }
        return null;
    }

    @PreDestroy
    public void close() {
        CloudWatchLoggingClient.destroy();
    }

    public void onApplicationEvent(ServerStartupEvent event) {
        CloudWatchLoggingClient.setLogging(this.internalLogging, event.getSource().getHost(), this.internalAppName);
    }
}

