/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aws.distributedconfiguration;

import io.micronaut.aws.distributedconfiguration.AwsDistributedConfiguration;
import io.micronaut.aws.distributedconfiguration.KeyValueFetcher;
import io.micronaut.context.env.Environment;
import io.micronaut.context.env.MapPropertySource;
import io.micronaut.context.env.PropertySource;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.discovery.config.ConfigurationClient;
import io.micronaut.runtime.ApplicationConfiguration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AwsDistributedConfigurationClient
implements ConfigurationClient {
    private static final Logger LOG = LoggerFactory.getLogger(AwsDistributedConfigurationClient.class);
    private static final String UNDERSCORE = "_";
    private final AwsDistributedConfiguration awsDistributedConfiguration;
    private final KeyValueFetcher keyValueFetcher;
    @Nullable
    private final String applicationName;

    public AwsDistributedConfigurationClient(AwsDistributedConfiguration awsDistributedConfiguration, KeyValueFetcher keyValueFetcher, @Nullable ApplicationConfiguration applicationConfiguration) {
        this.awsDistributedConfiguration = awsDistributedConfiguration;
        this.keyValueFetcher = keyValueFetcher;
        String string = this.applicationName = applicationConfiguration == null ? null : (String)applicationConfiguration.getName().orElse(null);
        if (LOG.isTraceEnabled()) {
            if (this.applicationName != null) {
                LOG.trace("application name: {}", (Object)this.applicationName);
            } else {
                LOG.trace("application name not set");
            }
        }
    }

    public Publisher<PropertySource> getPropertySources(Environment environment) {
        List<String> configurationResolutionPrefixes = this.generateConfigurationResolutionPrefixes(environment);
        HashMap<String, Map> configurationResolutionPrefixesValues = new HashMap<String, Map>();
        for (String string : configurationResolutionPrefixes) {
            Optional<Map> keyValuesOptional = this.keyValueFetcher.keyValuesByPrefix(string);
            if (!keyValuesOptional.isPresent()) continue;
            Map keyValues = keyValuesOptional.get();
            configurationResolutionPrefixesValues.put(string, keyValues);
        }
        HashSet allKeys = new HashSet();
        for (Object m : configurationResolutionPrefixesValues.values()) {
            allKeys.addAll(m.keySet());
        }
        HashMap hashMap = new HashMap();
        if (LOG.isTraceEnabled()) {
            LOG.trace("evaluating {} keys", (Object)allKeys.size());
        }
        block2: for (String k : allKeys) {
            if (hashMap.containsKey(k)) continue;
            for (String prefix : configurationResolutionPrefixes) {
                Map values;
                if (!configurationResolutionPrefixesValues.containsKey(prefix) || !(values = (Map)configurationResolutionPrefixesValues.get(prefix)).containsKey(k)) continue;
                if (LOG.isTraceEnabled()) {
                    LOG.trace("adding property {} from prefix {}", (Object)k, (Object)prefix);
                }
                hashMap.put(k, values.get(k));
                continue block2;
            }
        }
        String propertySourceName = this.getPropertySourceName();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Property source {} with #{} items", (Object)propertySourceName, (Object)hashMap.size());
        }
        if (LOG.isTraceEnabled()) {
            for (String k : hashMap.keySet()) {
                LOG.trace("property {} resolved", (Object)k);
            }
        }
        return Publishers.just((Object)new MapPropertySource(propertySourceName, hashMap));
    }

    @NonNull
    protected abstract String getPropertySourceName();

    @NonNull
    private List<String> generateConfigurationResolutionPrefixes(@NonNull Environment environment) {
        ArrayList<String> configurationResolutionPrefixes = new ArrayList<String>();
        if (this.applicationName != null) {
            if (this.awsDistributedConfiguration.isSearchActiveEnvironments()) {
                for (String name : environment.getActiveNames()) {
                    configurationResolutionPrefixes.add(this.prefix(this.applicationName, name));
                }
            }
            configurationResolutionPrefixes.add(this.prefix(this.applicationName));
        }
        if (this.awsDistributedConfiguration.isSearchCommonApplication()) {
            if (this.awsDistributedConfiguration.isSearchActiveEnvironments()) {
                for (String name : environment.getActiveNames()) {
                    configurationResolutionPrefixes.add(this.prefix(this.awsDistributedConfiguration.getCommonApplicationName(), name));
                }
            }
            configurationResolutionPrefixes.add(this.prefix(this.awsDistributedConfiguration.getCommonApplicationName()));
        }
        return configurationResolutionPrefixes;
    }

    @NonNull
    private String prefix(@NonNull String appName) {
        return this.prefix(appName, null);
    }

    @NonNull
    private String prefix(@NonNull String appName, @Nullable String envName) {
        if (envName != null) {
            return this.awsDistributedConfiguration.getPrefix() + appName + UNDERSCORE + envName + this.awsDistributedConfiguration.getDelimiter();
        }
        return this.awsDistributedConfiguration.getPrefix() + appName + this.awsDistributedConfiguration.getDelimiter();
    }
}

