/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aws.lambda.events.serde;

import com.amazonaws.services.lambda.runtime.serialization.util.SerializeUtil;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.TypeHint;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.util.NullableSerde;
import jakarta.inject.Singleton;
import java.io.IOException;
import org.joda.time.DateTime;

@Singleton
@Requires(classes={DateTime.class})
@TypeHint(typeNames={"org.joda.time.format.DateTimeFormatter", "org.joda.time.format.ISODateTimeFormat", "org.joda.time.ReadableInstant"})
public class JodaDateTimeSerde
implements NullableSerde<DateTime> {
    public void serialize(@NonNull Encoder encoder, @NonNull Serializer.EncoderContext context, @NonNull Argument<? extends DateTime> type, @NonNull DateTime value) throws IOException {
        encoder.encodeString(SerializeUtil.serializeDateTime((Object)value, (ClassLoader)this.getClass().getClassLoader()));
    }

    @NonNull
    public DateTime deserializeNonNull(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super DateTime> type) throws IOException {
        return (DateTime)SerializeUtil.deserializeDateTime(DateTime.class, (String)decoder.decodeString());
    }
}

