/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aws.lambda.events.serde;

import com.amazonaws.lambda.thirdparty.com.fasterxml.jackson.annotation.JsonGetter;
import com.amazonaws.lambda.thirdparty.com.fasterxml.jackson.annotation.JsonProperty;
import com.amazonaws.services.lambda.runtime.events.models.s3.S3EventNotification;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.annotation.SerdeImport;
import io.micronaut.serde.annotation.Serdeable;
import io.micronaut.serde.exceptions.SerdeException;
import jakarta.inject.Singleton;
import java.io.IOException;

@Internal
@Singleton
@SerdeImport(value=S3EventNotification.S3ObjectEntity.class, mixin=S3ObjectEntityMixin.class, deserializable=false)
public class S3ObjectEntitySerde
implements Deserializer<S3EventNotification.S3ObjectEntity> {
    private static final String KEY = "key";
    private static final String SIZE = "size";
    private static final String ETAG = "eTag";
    private static final String VERSION_ID = "versionId";
    private static final String SEQUENCER = "sequencer";

    @NonNull
    public Deserializer<S3EventNotification.S3ObjectEntity> createSpecific(Deserializer.DecoderContext context, @NonNull Argument<? super S3EventNotification.S3ObjectEntity> type) throws SerdeException {
        final Argument arg = Argument.of(S3ObjectEntityDes.class);
        final Deserializer specific = context.findDeserializer(S3ObjectEntityDes.class).createSpecific(context, arg);
        return new Deserializer<S3EventNotification.S3ObjectEntity>(){

            @Nullable
            public S3EventNotification.S3ObjectEntity deserialize(@NonNull Decoder decoder, Deserializer.DecoderContext context, @NonNull Argument<? super S3EventNotification.S3ObjectEntity> type) throws IOException {
                return ((S3ObjectEntityDes)specific.deserialize((Decoder)decoder, (Deserializer.DecoderContext)context, (Argument)arg)).actual;
            }
        };
    }

    @Nullable
    public S3EventNotification.S3ObjectEntity deserialize(@NonNull Decoder decoder, @NonNull Deserializer.DecoderContext context, @NonNull Argument<? super S3EventNotification.S3ObjectEntity> type) throws IOException {
        throw new UnsupportedOperationException("Use specific deserializer");
    }

    @Serdeable.Deserializable
    static final class S3ObjectEntityDes {
        final S3EventNotification.S3ObjectEntity actual;

        S3ObjectEntityDes(@JsonProperty(value="key") String key, @JsonProperty(value="size") Long size, @JsonProperty(value="eTag") String eTag, @JsonProperty(value="versionId") String versionId, @JsonProperty(value="sequencer") String sequencer) {
            this.actual = new S3EventNotification.S3ObjectEntity(key, size, eTag, versionId, sequencer);
        }
    }

    static interface S3ObjectEntityMixin {
        @JsonGetter(value="key")
        public String getKey();

        @JsonGetter(value="size")
        public Long getSizeAsLong();

        @JsonGetter(value="eTag")
        public String geteTag();

        @JsonGetter(value="versionId")
        public String getVersionId();

        @JsonGetter(value="sequencer")
        public String getSequencer();
    }
}

