/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aws.lambda.events.serde;

import com.amazonaws.lambda.thirdparty.com.fasterxml.jackson.annotation.JsonGetter;
import com.amazonaws.lambda.thirdparty.com.fasterxml.jackson.annotation.JsonProperty;
import com.amazonaws.services.lambda.runtime.events.S3Event;
import com.amazonaws.services.lambda.runtime.events.models.s3.S3EventNotification;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.annotation.SerdeImport;
import io.micronaut.serde.annotation.Serdeable;
import io.micronaut.serde.exceptions.SerdeException;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.util.List;

@SerdeImport(value=S3Event.class, mixin=Mixin.class, deserializable=false)
@Singleton
@Internal
public class S3EventSerde
implements Deserializer<S3Event> {
    private static final String RECORDS = "Records";

    @NonNull
    public Deserializer<S3Event> createSpecific(Deserializer.DecoderContext context, @NonNull Argument<? super S3Event> type) throws SerdeException {
        final Argument arg = Argument.of(S3EventDes.class);
        final Deserializer specific = context.findDeserializer(S3EventDes.class).createSpecific(context, arg);
        return new Deserializer<S3Event>(){

            @Nullable
            public S3Event deserialize(@NonNull Decoder decoder, Deserializer.DecoderContext context, @NonNull Argument<? super S3Event> type) throws IOException {
                return ((S3EventDes)specific.deserialize((Decoder)decoder, (Deserializer.DecoderContext)context, (Argument)arg)).actual;
            }
        };
    }

    @Nullable
    public S3Event deserialize(@NonNull Decoder decoder, Deserializer.DecoderContext context, @NonNull Argument<? super S3Event> type) throws IOException {
        throw new UnsupportedOperationException("Use specific deserializer");
    }

    @Serdeable.Deserializable
    static final class S3EventDes {
        final S3Event actual;

        S3EventDes(@JsonProperty(value="Records") List<S3EventNotification.S3EventNotificationRecord> records) {
            this.actual = new S3Event(records);
        }
    }

    static interface Mixin {
        @JsonGetter(value="Records")
        public List<S3EventNotification.S3EventNotificationRecord> getRecords();
    }
}

