/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery.aws.parameterstore;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.env.Environment;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.discovery.aws.parameterstore.AWSParameterQueryProvider;
import io.micronaut.discovery.aws.parameterstore.AWSParameterStoreConfiguration;
import io.micronaut.discovery.aws.parameterstore.ParameterQuery;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Internal
@Singleton
@BootstrapContextCompatible
final class DefaultParameterQueryProvider
implements AWSParameterQueryProvider {
    private static int basePriority = -100;
    private static int envBasePriority = basePriority + 50;

    DefaultParameterQueryProvider() {
    }

    @Override
    public List<ParameterQuery> getParameterQueries(Environment environment, @Nullable String serviceId, AWSParameterStoreConfiguration configuration) {
        ArrayList activeNames = configuration.isSearchActiveEnvironments() ? new ArrayList(environment.getActiveNames()) : Collections.emptyList();
        String path = configuration.getRootHierarchyPath();
        Object normalizedPath = !path.endsWith("/") ? path + "/" : path;
        String commonConfigPath = (String)normalizedPath + "application";
        boolean hasApplicationSpecificConfig = serviceId != null;
        String applicationSpecificPath = hasApplicationSpecificConfig ? (String)normalizedPath + serviceId : null;
        ArrayList<ParameterQuery> queries = new ArrayList<ParameterQuery>();
        this.addNameAndPathQueries(queries, commonConfigPath, "application", basePriority + 1);
        if (hasApplicationSpecificConfig) {
            this.addNameAndPathQueries(queries, applicationSpecificPath, serviceId, basePriority + 2);
        }
        for (int i = 0; i < activeNames.size(); ++i) {
            String activeName = (String)activeNames.get(i);
            String environmentSpecificPath = commonConfigPath + "_" + activeName;
            String propertySourceName = "application[" + activeName + "]";
            int priority = envBasePriority + i * 2;
            this.addNameAndPathQueries(queries, environmentSpecificPath, propertySourceName, priority);
            if (!hasApplicationSpecificConfig) continue;
            String appEnvironmentSpecificPath = applicationSpecificPath + "_" + activeName;
            propertySourceName = serviceId + "[" + activeName + "]";
            this.addNameAndPathQueries(queries, appEnvironmentSpecificPath, propertySourceName, priority + 1);
        }
        return queries;
    }

    private void addNameAndPathQueries(List<ParameterQuery> queries, String value, String propertySourceName, int priority) {
        queries.add(new ParameterQuery(value, propertySourceName, priority, true));
        queries.add(new ParameterQuery(value, propertySourceName, priority, false));
    }
}

