/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery.aws.parameterstore;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.env.Environment;
import io.micronaut.context.env.PropertySource;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.discovery.aws.parameterstore.AWSParameterQueryProvider;
import io.micronaut.discovery.aws.parameterstore.AWSParameterStoreConfiguration;
import io.micronaut.discovery.aws.parameterstore.ParameterQuery;
import io.micronaut.discovery.aws.servicediscovery.AwsServiceDiscoveryConfiguration;
import io.micronaut.discovery.client.ClientUtil;
import io.micronaut.discovery.config.ConfigurationClient;
import io.micronaut.runtime.ApplicationConfiguration;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.services.ssm.SsmAsyncClient;
import software.amazon.awssdk.services.ssm.model.GetParametersByPathRequest;
import software.amazon.awssdk.services.ssm.model.GetParametersByPathResponse;
import software.amazon.awssdk.services.ssm.model.GetParametersRequest;
import software.amazon.awssdk.services.ssm.model.GetParametersResponse;
import software.amazon.awssdk.services.ssm.model.Parameter;
import software.amazon.awssdk.services.ssm.model.ParameterType;

@Singleton
@Requirements(value={@Requires(env={"ec2"}), @Requires(beans={AWSParameterStoreConfiguration.class, SsmAsyncClient.class})})
@BootstrapContextCompatible
public class AWSParameterStoreConfigClient
implements ConfigurationClient {
    private static final Logger LOG = LoggerFactory.getLogger(AWSParameterStoreConfigClient.class);
    private final AWSParameterStoreConfiguration awsParameterStoreConfiguration;
    private final String serviceId;
    private SsmAsyncClient client;
    private ExecutorService executorService;
    private AWSParameterQueryProvider queryProvider;

    AWSParameterStoreConfigClient(SsmAsyncClient asyncClient, AWSParameterStoreConfiguration awsParameterStoreConfiguration, ApplicationConfiguration applicationConfiguration, AWSParameterQueryProvider queryProvider, @Nullable AwsServiceDiscoveryConfiguration serviceDiscoveryConfiguration) {
        this.awsParameterStoreConfiguration = awsParameterStoreConfiguration;
        this.client = asyncClient;
        this.serviceId = serviceDiscoveryConfiguration != null ? serviceDiscoveryConfiguration.getAwsServiceId() : (String)applicationConfiguration.getName().orElse(null);
        this.queryProvider = queryProvider;
    }

    public Publisher<PropertySource> getPropertySources(Environment environment) {
        if (!this.awsParameterStoreConfiguration.isEnabled()) {
            return Flux.empty();
        }
        List<ParameterQuery> queries = this.queryProvider.getParameterQueries(environment, this.serviceId, this.awsParameterStoreConfiguration);
        Flux queryResults = Flux.concat((Publisher)Flux.fromIterable(queries).map(this::getParameters));
        Flux propertySourceFlowable = queryResults.flatMap(this::buildLocalSource).reduce(new HashMap(), AWSParameterStoreConfigClient::mergeLocalSources).flatMapMany(AWSParameterStoreConfigClient::toPropertySourcePublisher);
        return propertySourceFlowable.onErrorResume(AWSParameterStoreConfigClient::onPropertySourceError);
    }

    public String getDescription() {
        return "AWS Parameter Store";
    }

    private static Publisher<? extends PropertySource> onPropertySourceError(Throwable throwable) {
        if (throwable instanceof ConfigurationException) {
            return Flux.error((Throwable)throwable);
        }
        return Flux.error((Throwable)new ConfigurationException("Error reading distributed configuration from AWS Parameter Store: " + throwable.getMessage(), throwable));
    }

    private static Mono<? extends GetParametersResponse> onGetParametersError(Throwable throwable) {
        if (throwable instanceof SdkClientException) {
            return Mono.error((Throwable)throwable);
        }
        return Mono.error((Throwable)new ConfigurationException("Error reading distributed configuration from AWS Parameter Store: " + throwable.getMessage(), throwable));
    }

    private static Mono<? extends GetParametersByPathResponse> onGetParametersByPathResult(Throwable throwable) {
        if (throwable instanceof SdkClientException) {
            return Mono.error((Throwable)throwable);
        }
        return Mono.error((Throwable)new ConfigurationException("Error reading distributed configuration from AWS Parameter Store: " + throwable.getMessage(), throwable));
    }

    private Publisher<ParameterQueryResult> getParameters(ParameterQuery query) {
        String path = query.getPath();
        return query.isName() ? Flux.from(this.getParameters(path)).map(r -> new ParameterQueryResult(query, r.parameters())) : Flux.from(this.getHierarchy(path, new ArrayList<Parameter>(), null)).map(r -> new ParameterQueryResult(query, (List<Parameter>)r));
    }

    private Flux<LocalSource> buildLocalSource(ParameterQueryResult queryResult) {
        String key = queryResult.query.getPath();
        if (queryResult.parameters.isEmpty()) {
            LOG.trace("parameterBasePath={} no parameters found", (Object)key);
            return Flux.empty();
        }
        Map<String, Object> properties = AWSParameterStoreConfigClient.convertParametersToMap(queryResult);
        String propertySourceName = queryResult.query.getPropertySourceName();
        if (LOG.isTraceEnabled()) {
            properties.keySet().iterator().forEachRemaining(param -> LOG.trace("param found: parameterBasePath={} parameter={}", (Object)queryResult.query.getPath(), param));
        }
        LocalSource localSource = new LocalSource(queryResult.query.getPriority(), propertySourceName);
        localSource.putAll(properties);
        return Flux.just((Object)localSource);
    }

    private Flux<List<Parameter>> getHierarchy(String path, List<Parameter> parameters, String nextToken) {
        Flux paramPage = Flux.from(this.getHierarchy(path, nextToken));
        return paramPage.flatMap(getParametersByPathResult -> {
            List params = getParametersByPathResult.parameters();
            if (getParametersByPathResult.nextToken() != null) {
                return Flux.merge((Publisher[])new Publisher[]{Flux.just((Object)parameters), this.getHierarchy(path, params, getParametersByPathResult.nextToken())});
            }
            return Flux.merge((Publisher[])new Publisher[]{Flux.just((Object)parameters), Flux.just((Object)params)});
        });
    }

    private Publisher<GetParametersByPathResponse> getHierarchy(String path, String nextToken) {
        LOG.trace("Retrieving parameters by path {}, pagination requested: {}", (Object)path, (Object)(nextToken != null ? 1 : 0));
        GetParametersByPathRequest getRequest = (GetParametersByPathRequest)GetParametersByPathRequest.builder().withDecryption(Boolean.valueOf(this.awsParameterStoreConfiguration.getUseSecureParameters())).path(path).recursive(Boolean.valueOf(true)).nextToken(nextToken).build();
        CompletableFuture future = this.client.getParametersByPath(getRequest);
        Mono invokeFlowable = Mono.fromFuture((CompletableFuture)future);
        if (this.executorService != null) {
            invokeFlowable = invokeFlowable.subscribeOn(Schedulers.fromExecutor((Executor)this.executorService));
        }
        return invokeFlowable.onErrorResume(AWSParameterStoreConfigClient::onGetParametersByPathResult);
    }

    private Publisher<GetParametersResponse> getParameters(String path) {
        GetParametersRequest getRequest = (GetParametersRequest)GetParametersRequest.builder().withDecryption(Boolean.valueOf(this.awsParameterStoreConfiguration.getUseSecureParameters())).names(new String[]{path}).build();
        CompletableFuture future = this.client.getParameters(getRequest);
        Mono invokeFlowable = Mono.fromFuture((CompletableFuture)future);
        if (this.executorService != null) {
            invokeFlowable = invokeFlowable.subscribeOn(Schedulers.fromExecutor((Executor)this.executorService));
        }
        return invokeFlowable.onErrorResume(AWSParameterStoreConfigClient::onGetParametersError);
    }

    @Inject
    void setExecutionService(@Named(value="io") @Nullable ExecutorService executorService) {
        if (executorService != null) {
            this.executorService = executorService;
        }
    }

    private Set<String> calcPropertySourceNames(String prefix, List<String> activeNames) {
        return ClientUtil.calcPropertySourceNames((String)prefix, activeNames, (String)"_");
    }

    private static Map<String, Object> convertParametersToMap(ParameterQueryResult queryResult) {
        HashMap<String, Object> output = new HashMap<String, Object>();
        for (Parameter param : queryResult.parameters) {
            String key = param.name().substring(queryResult.query.getPath().length());
            if (key.length() > 1) {
                key = key.substring(1).replace("/", ".");
            }
            if (ParameterType.STRING_LIST.equals((Object)param.type())) {
                String[] items = param.value().split(",");
                output.put(key, Arrays.asList(items));
                continue;
            }
            output.put(key, param.value());
        }
        LOG.trace("Converted " + output);
        return output;
    }

    private static Map<String, LocalSource> mergeLocalSources(Map<String, LocalSource> accumulator, LocalSource localSource) {
        LocalSource previous = accumulator.get(localSource.name);
        if (previous == null) {
            accumulator.put(localSource.name, localSource);
        } else {
            LOG.trace("merging into existing source {} from {}", (Object)localSource.name, (Object)localSource.priority);
            if (previous.priority != localSource.priority) {
                LOG.warn("local source {} redeclared with priority {} instead ofg {}, ignoring", new Object[]{localSource.name, localSource.priority, previous.priority});
            }
            previous.putAll(localSource.values);
        }
        return accumulator;
    }

    private static Flux<PropertySource> toPropertySourcePublisher(Map<String, LocalSource> localSourceMap) {
        return Flux.fromIterable(localSourceMap.values()).map(localSource -> {
            LOG.trace("source={} got priority={}", (Object)localSource.name, (Object)localSource.priority);
            return PropertySource.of((String)("route53-" + localSource.name), localSource.values, (int)localSource.priority);
        });
    }

    protected void setClient(SsmAsyncClient client) {
        this.client = client;
    }

    protected SsmAsyncClient getClient() {
        return this.client;
    }

    protected AWSParameterQueryProvider getQueryProvider() {
        return this.queryProvider;
    }

    protected void setQueryProvider(AWSParameterQueryProvider queryProvider) {
        this.queryProvider = queryProvider;
    }

    static class ParameterQueryResult {
        private final ParameterQuery query;
        private final List<Parameter> parameters;

        public ParameterQueryResult(ParameterQuery query, List<Parameter> parameters) {
            this.query = query;
            this.parameters = parameters;
        }
    }

    private static class LocalSource {
        private final int priority;
        private final String name;
        private final Map<String, Object> values = new LinkedHashMap<String, Object>();

        LocalSource(int priority, String name) {
            this.priority = priority;
            this.name = name;
        }

        void putAll(Map<String, Object> values) {
            this.values.putAll(values);
        }
    }
}

