/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aws.sdk.v2.client.netty;

import io.micronaut.aws.sdk.v2.client.netty.NettyClientConfiguration;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Requires;
import javax.inject.Singleton;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;

@Factory
public class NettyClientFactory {
    public static final String ASYNC_SERVICE_IMPL = "software.amazon.awssdk.http.async.service.impl";
    public static final String NETTY_SDK_ASYNC_HTTP_SERVICE = "software.amazon.awssdk.http.nio.netty.NettySdkAsyncHttpService";

    @Bean(preDestroy="close")
    @Singleton
    public SdkAsyncHttpClient nettyClient(NettyClientConfiguration configuration) {
        return this.doCreateClient(configuration);
    }

    @Bean(preDestroy="close")
    @Singleton
    @Requires(property="software.amazon.awssdk.http.async.service.impl", value="software.amazon.awssdk.http.nio.netty.NettySdkAsyncHttpService")
    public SdkAsyncHttpClient systemPropertyClient(NettyClientConfiguration configuration) {
        return this.doCreateClient(configuration);
    }

    private SdkAsyncHttpClient doCreateClient(NettyClientConfiguration configuration) {
        return configuration.getBuilder().build();
    }
}

