/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aws.sdk.v2.service.s3;

import io.micronaut.aws.sdk.v2.service.AwsClientFactory;
import io.micronaut.aws.sdk.v2.service.s3.S3ConfigurationProperties;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Requires;
import javax.inject.Singleton;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProviderChain;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.regions.providers.AwsRegionProviderChain;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3AsyncClientBuilder;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.S3Configuration;

@Factory
public class S3ClientFactory
extends AwsClientFactory<S3ClientBuilder, S3AsyncClientBuilder, S3Client, S3AsyncClient> {
    private final S3ConfigurationProperties configuration;

    public S3ClientFactory(AwsCredentialsProviderChain credentialsProvider, AwsRegionProviderChain regionProvider, S3ConfigurationProperties configuration) {
        super(credentialsProvider, regionProvider);
        this.configuration = configuration;
    }

    @Override
    protected S3ClientBuilder createSyncBuilder() {
        return (S3ClientBuilder)S3Client.builder().serviceConfiguration((S3Configuration)this.configuration.getBuilder().build());
    }

    @Override
    protected S3AsyncClientBuilder createAsyncBuilder() {
        return (S3AsyncClientBuilder)S3AsyncClient.builder().serviceConfiguration((S3Configuration)this.configuration.getBuilder().build());
    }

    @Override
    @Singleton
    public S3ClientBuilder syncBuilder(SdkHttpClient httpClient) {
        return (S3ClientBuilder)super.syncBuilder(httpClient);
    }

    @Override
    @Bean(preDestroy="close")
    @Singleton
    public S3Client syncClient(S3ClientBuilder builder) {
        return (S3Client)super.syncClient(builder);
    }

    @Override
    @Singleton
    @Requires(beans={SdkAsyncHttpClient.class})
    public S3AsyncClientBuilder asyncBuilder(SdkAsyncHttpClient httpClient) {
        return (S3AsyncClientBuilder)super.asyncBuilder(httpClient);
    }

    @Override
    @Bean(preDestroy="close")
    @Singleton
    @Requires(beans={SdkAsyncHttpClient.class})
    public S3AsyncClient asyncClient(S3AsyncClientBuilder builder) {
        return (S3AsyncClient)super.asyncClient(builder);
    }
}

