/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aws.sdk.v2.service.sqs;

import io.micronaut.aws.sdk.v2.service.AwsClientFactory;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Requires;
import javax.inject.Singleton;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProviderChain;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.regions.providers.AwsRegionProviderChain;
import software.amazon.awssdk.services.sqs.SqsAsyncClient;
import software.amazon.awssdk.services.sqs.SqsAsyncClientBuilder;
import software.amazon.awssdk.services.sqs.SqsClient;
import software.amazon.awssdk.services.sqs.SqsClientBuilder;

@Factory
public class SqsClientFactory
extends AwsClientFactory<SqsClientBuilder, SqsAsyncClientBuilder, SqsClient, SqsAsyncClient> {
    protected SqsClientFactory(AwsCredentialsProviderChain credentialsProvider, AwsRegionProviderChain regionProvider) {
        super(credentialsProvider, regionProvider);
    }

    @Override
    protected SqsClientBuilder createSyncBuilder() {
        return SqsClient.builder();
    }

    @Override
    protected SqsAsyncClientBuilder createAsyncBuilder() {
        return SqsAsyncClient.builder();
    }

    @Override
    @Singleton
    public SqsClientBuilder syncBuilder(SdkHttpClient httpClient) {
        return (SqsClientBuilder)super.syncBuilder(httpClient);
    }

    @Override
    @Bean(preDestroy="close")
    @Singleton
    public SqsClient syncClient(SqsClientBuilder builder) {
        return (SqsClient)super.syncClient(builder);
    }

    @Override
    @Singleton
    @Requires(beans={SdkAsyncHttpClient.class})
    public SqsAsyncClientBuilder asyncBuilder(SdkAsyncHttpClient httpClient) {
        return (SqsAsyncClientBuilder)super.asyncBuilder(httpClient);
    }

    @Override
    @Bean(preDestroy="close")
    @Singleton
    @Requires(beans={SdkAsyncHttpClient.class})
    public SqsAsyncClient asyncClient(SqsAsyncClientBuilder builder) {
        return (SqsAsyncClient)super.asyncClient(builder);
    }
}

